/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import winterwell.markdown.Activator;
import winterwell.markdown.editors.ColorManager;
import winterwell.markdown.editors.MDConfiguration;
import winterwell.markdown.editors.MarkdownContentOutlinePage;
import winterwell.markdown.pagemodel.MarkdownPage;
import winterwell.markdown.preferences.MarkdownPreferencePage;

public class MarkdownEditor
extends TextEditor
implements IDocumentListener {
    private static final int MAX_TASK_MSG_LENGTH = 80;
    private ColorManager colorManager;
    private MarkdownContentOutlinePage fOutlinePage = null;
    IDocument oldDoc = null;
    private MarkdownPage page;
    private boolean pageDirty = true;
    private ProjectionSupport projectionSupport;
    private final IPreferenceStore pStore;
    private IPropertyChangeListener prefChangeListener;
    private static final Map<IDocument, MarkdownEditor> doc2editor = new HashMap<IDocument, MarkdownEditor>();
    private static final Annotation[] ANNOTATION_ARRAY = new Annotation[0];
    private static final Position[] POSITION_ARRAY = new Position[0];
    private boolean haveRunFolding = false;
    private Map<Annotation, Position> oldAnnotations = new HashMap<Annotation, Position>(0);

    public MarkdownEditor() {
        this.pStore = Activator.getDefault().getPreferenceStore();
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new MDConfiguration(this.colorManager, this.getPreferenceStore()));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getSourceViewer() instanceof ProjectionViewer) {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
            this.projectionSupport.install();
            viewer.doOperation(19);
        }
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        StyledText widget = viewer.getTextWidget();
        this.prefChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("Pref_WordWrap")) {
                    widget.setWordWrap(MarkdownPreferencePage.wordWrap());
                }
            }
        };
        this.pStore.addPropertyChangeListener(this.prefChangeListener);
        if (MarkdownPreferencePage.wordWrap()) {
            widget.setWordWrap(true);
        }
        return viewer;
    }

    public void dispose() {
        if (this.pStore != null) {
            this.pStore.removePropertyChangeListener(this.prefChangeListener);
        }
        this.colorManager.dispose();
        super.dispose();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.pageDirty = true;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IDocument doc;
        if (this.oldDoc != null) {
            this.oldDoc.removeDocumentListener((IDocumentListener)this);
            if (doc2editor.get(this.oldDoc) == this) {
                doc2editor.remove(this.oldDoc);
            }
        }
        super.doSetInput(input);
        this.oldDoc = doc = this.getDocument();
        if (doc == null) {
            return;
        }
        doc.addDocumentListener((IDocumentListener)this);
        doc2editor.put(doc, this);
        this.haveRunFolding = false;
        this.updateSectionFoldingAnnotations(null);
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new MarkdownContentOutlinePage(this.getDocumentProvider(), this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public IDocument getDocument() {
        IEditorInput input = this.getEditorInput();
        IDocumentProvider docProvider = this.getDocumentProvider();
        return docProvider == null ? null : docProvider.getDocument((Object)input);
    }

    public MarkdownPage getMarkdownPage() {
        if (this.pageDirty) {
            this.updateMarkdownPage();
        }
        return this.page;
    }

    public int getPrintColumns() {
        return this.getPreferenceStore().getInt("printMarginColumn");
    }

    public String getText() {
        IDocument doc = this.getDocument();
        return doc == null ? null : doc.get();
    }

    private void updateMarkdownPage() {
        String text = this.getText();
        if (text == null) {
            text = "";
        }
        this.page = new MarkdownPage(text);
        this.pageDirty = false;
    }

    void updateTaskTags(IRegion region) {
        try {
            boolean useTags = this.pStore.getBoolean("Pref_TaskTagsOn");
            if (!useTags) {
                return;
            }
            String tagString = this.pStore.getString("Pref_TaskTags");
            List<String> tags = Arrays.asList(tagString.split(","));
            IFile docFile = this.getResource(this);
            IMarker[] taskMarkers = docFile.findMarkers("org.eclipse.core.resources.taskmarker", true, 2);
            ArrayList<IMarker> markers = new ArrayList<IMarker>(Arrays.asList(taskMarkers));
            List<String> text = this.getMarkdownPage().getText();
            int i = 1;
            while (i <= text.size()) {
                String line = text.get(i - 1);
                for (String tag : tags) {
                    int tagIndex = line.indexOf(tag = tag.trim());
                    if (tagIndex == -1) continue;
                    IMarker exists = this.updateTaskTags2_checkExisting(i, tagIndex, line, markers);
                    if (exists != null) {
                        markers.remove(exists);
                        continue;
                    }
                    IMarker marker = docFile.createMarker("org.eclipse.core.resources.taskmarker");
                    marker.setAttribute("priority", 1);
                    String msg = line.substring(line.indexOf(tag), Math.min(tagIndex + 80, line.length() - 1));
                    marker.setAttribute("message", (Object)msg);
                    marker.setAttribute("lineNumber", i);
                }
                ++i;
            }
            for (IMarker m : markers) {
                try {
                    m.delete();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
    }

    private IMarker updateTaskTags2_checkExisting(int i, int tagIndex, String line, List<IMarker> markers) {
        String tagMessage = line.substring(tagIndex).trim();
        for (IMarker marker : markers) {
            try {
                String txt;
                Integer lineNum = (Integer)marker.getAttribute("lineNumber");
                if (i != lineNum || !tagMessage.equals(txt = ((String)marker.getAttribute("message")).trim())) continue;
                return marker;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private IFile getResource(MarkdownEditor markdownEditor) {
        IPathEditorInput input = (IPathEditorInput)this.getEditorInput();
        IPath path = input.getPath();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile[] files = root.findFilesForLocation(path);
        if (files.length != 1) {
            return null;
        }
        IFile docFile = files[0];
        return docFile;
    }

    public static MarkdownEditor getEditor(IDocument doc) {
        return doc2editor.get(doc);
    }

    public void updatePage(IRegion region) {
        this.updateTaskTags(region);
        this.updateSectionFoldingAnnotations(region);
    }

    private void updateSectionFoldingAnnotations(IRegion region) {
        if (!this.haveRunFolding) {
            region = null;
        }
        if (!(this.getSourceViewer() instanceof ProjectionViewer)) {
            return;
        }
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        MarkdownPage mPage = this.getMarkdownPage();
        List<MarkdownPage.Header> headers = mPage.getHeadings(null);
        HashMap<Annotation, Position> annotations = new HashMap<Annotation, Position>();
        IDocument doc = this.getDocument();
        this.updateSectionFoldingAnnotations2(doc, headers, annotations, doc.getLength());
        Position[] newValues = annotations.values().toArray(POSITION_ARRAY);
        ArrayList<Annotation> deletedAnnotations = new ArrayList<Annotation>();
        for (Map.Entry<Annotation, Position> ae : this.oldAnnotations.entrySet()) {
            Position oldp = ae.getValue();
            boolean stillExists = false;
            Position[] positionArray = newValues;
            int n = newValues.length;
            int n2 = 0;
            while (n2 < n) {
                Position newp = positionArray[n2];
                if (oldp.equals((Object)newp)) {
                    annotations.remove(newp);
                    stillExists = true;
                    break;
                }
                ++n2;
            }
            if (stillExists || !this.intersectsRegion(oldp, region)) continue;
            deletedAnnotations.add(ae.getKey());
        }
        Annotation[] annotationArray = annotations.keySet().toArray(ANNOTATION_ARRAY);
        int n = annotationArray.length;
        int n3 = 0;
        while (n3 < n) {
            Annotation a = annotationArray[n3];
            Position p = (Position)annotations.get(a);
            if (!this.intersectsRegion(p, region)) {
                annotations.remove(a);
            }
            ++n3;
        }
        ProjectionAnnotationModel annotationModel = viewer.getProjectionAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        annotationModel.modifyAnnotations(deletedAnnotations.toArray(ANNOTATION_ARRAY), annotations, null);
        this.oldAnnotations.putAll(annotations);
        for (Annotation a : deletedAnnotations) {
            this.oldAnnotations.remove(a);
        }
        this.haveRunFolding = true;
    }

    private boolean intersectsRegion(Position p, IRegion region) {
        if (region == null) {
            return true;
        }
        if (p.offset > region.getOffset() + region.getLength()) {
            return false;
        }
        return p.offset + p.length >= region.getOffset();
    }

    private void updateSectionFoldingAnnotations2(IDocument doc, List<MarkdownPage.Header> headers, Map<Annotation, Position> newAnnotations, int endParent) {
        int i = 0;
        while (i < headers.size()) {
            MarkdownPage.Header header = headers.get(i);
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            try {
                int line = header.getLineNumber();
                int start = doc.getLineOffset(line);
                int end = i == headers.size() - 1 ? endParent : doc.getLineOffset(headers.get(i + 1).getLineNumber());
                Position position = new Position(start, end - start);
                newAnnotations.put((Annotation)annotation, position);
                List<MarkdownPage.Header> subHeaders = header.getSubHeaders();
                if (subHeaders.size() > 0) {
                    this.updateSectionFoldingAnnotations2(doc, subHeaders, newAnnotations, end);
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            ++i;
        }
    }
}

