/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import winterwell.markdown.StringMethods;
import winterwell.utils.containers.Pair;

public class MDTextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        try {
            IDocument doc = textViewer.getDocument();
            String text = doc.get(region.getOffset(), region.getLength());
            return "<b>" + text + "</b>";
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        try {
            Pair<Integer> altRegion;
            IDocument doc = textViewer.getDocument();
            int line = doc.getLineOfOffset(offset);
            int lineOffset = doc.getLineOffset(line);
            int lineLength = doc.getLineLength(line);
            String text = doc.get(lineOffset, lineLength);
            Pair<Integer> urlRegion = StringMethods.findEnclosingRegion(text, offset - lineOffset, '(', ')');
            if (urlRegion == null) {
                altRegion = StringMethods.findEnclosingRegion(text, offset - lineOffset, '[', ']');
                if (altRegion == null) {
                    return null;
                }
                urlRegion = StringMethods.findEnclosingRegion(text, (Integer)altRegion.second, '(', ')');
            } else {
                altRegion = StringMethods.findEnclosingRegion(text, (Integer)urlRegion.first - 1, '[', ']');
            }
            if (urlRegion == null) return null;
            if (altRegion == null) {
                return null;
            }
            if (text.charAt((Integer)altRegion.first - 1) == '!') return new Region((Integer)urlRegion.first + 1 + lineOffset, (Integer)urlRegion.second - (Integer)urlRegion.first - 2);
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

