/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter.guts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Random;
import winterwell.jtwitter.InternalUtils;

public class ClientHttpRequest
extends Observable {
    URLConnection connection;
    OutputStream os = null;
    Map<String, String> cookies = new HashMap<String, String>();
    String rawCookies = "";
    private static Charset UTF_8;
    private static Random random;
    String boundary = "---------------------------" + ClientHttpRequest.randomString() + ClientHttpRequest.randomString() + ClientHttpRequest.randomString();
    private boolean isCanceled = false;
    private int bytesSent = 0;

    protected void connect() throws IOException {
        if (this.os == null) {
            this.os = this.connection.getOutputStream();
        }
    }

    protected void write(char c) throws IOException {
        this.connect();
        this.os.write(c);
    }

    protected void write(String string) throws IOException {
        this.connect();
        if (UTF_8 != null) {
            this.os.write(string.getBytes(UTF_8));
            return;
        }
        this.os.write(string.getBytes());
    }

    protected long newlineNumBytes() {
        return 2L;
    }

    protected void newline() throws IOException {
        this.connect();
        this.write("\r\n");
    }

    protected void writeln(String string) throws IOException {
        this.connect();
        this.write(string);
        this.newline();
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    private long boundaryNumBytes() {
        return this.boundary.length() + 2;
    }

    private void boundary() throws IOException {
        this.write("--");
        this.write(this.boundary);
    }

    public ClientHttpRequest(URLConnection uRLConnection) throws IOException {
        this.connection = uRLConnection;
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public ClientHttpRequest(URL uRL) throws IOException {
        this(uRL.openConnection());
    }

    public ClientHttpRequest(String string) throws IOException {
        this(new URL(string));
    }

    private void postCookies() {
        StringBuffer stringBuffer = new StringBuffer(this.rawCookies);
        for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(entry.getKey() + "=" + entry.getValue());
        }
        if (stringBuffer.length() > 0) {
            this.connection.setRequestProperty("Cookie", stringBuffer.toString());
        }
    }

    public void setCookies(String string) throws IOException {
        this.rawCookies = string == null ? "" : string;
        this.cookies.clear();
    }

    public void setCookie(String string, String string2) throws IOException {
        this.cookies.put(string, string2);
    }

    public void setCookies(Map map) throws IOException {
        if (map != null) {
            this.cookies.putAll(map);
        }
    }

    public void setCookies(String[] stringArray) throws IOException {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length - 1; i += 2) {
                this.setCookie(stringArray[i], stringArray[i + 1]);
            }
        }
    }

    private long writeNameNumBytes(String string) {
        return this.newlineNumBytes() + (long)"Content-Disposition: form-data; name=\"".length() + (long)string.getBytes().length + 1L;
    }

    private void writeName(String string) throws IOException {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(string);
        this.write('\"');
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        this.bytesSent = 0;
        this.isCanceled = false;
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                outputStream.write(byArray, 0, n);
                this.bytesSent += n;
                if (this.isCanceled) {
                    throw new IOException("Canceled");
                }
                outputStream.flush();
                this.setChanged();
                this.notifyObservers(this.bytesSent);
                this.clearChanged();
            }
        }
        outputStream.flush();
        byArray = null;
    }

    public void setParameter(String string, String string2) throws IOException {
        this.boundary();
        this.writeName(string);
        this.newline();
        this.newline();
        this.writeln(string2);
    }

    public void setParameter(String string, String string2, InputStream inputStream) throws IOException {
        this.boundary();
        this.writeName(string);
        this.write("; filename=\"");
        this.write(string2);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String string3 = URLConnection.guessContentTypeFromName(string2);
        if (string3 == null) {
            string3 = "application/octet-stream";
        }
        this.writeln(string3);
        this.newline();
        this.pipe(inputStream, this.os);
        this.newline();
    }

    public long getFilePostSize(String string, File file) {
        String string2 = file.getPath();
        String string3 = URLConnection.guessContentTypeFromName(string2);
        if (string3 == null) {
            string3 = "application/octet-stream";
        }
        return this.boundaryNumBytes() + this.writeNameNumBytes(string) + (long)"; filename=\"".length() + (long)string2.getBytes().length + 1L + this.newlineNumBytes() + (long)"Content-Type: ".length() + (long)string3.length() + this.newlineNumBytes() + this.newlineNumBytes() + file.length() + this.newlineNumBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String string, File file) throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            this.setParameter(string, file.getPath(), fileInputStream);
        }
    }

    public void setParameter(Object object, Object object2) throws IOException {
        if (object2 instanceof File) {
            this.setParameter(object.toString(), (File)object2);
        } else {
            this.setParameter(object.toString(), object2.toString());
        }
    }

    public void setParameters(Map map) throws IOException {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.setParameter((Object)entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public void setParameters(Object ... objectArray) throws IOException {
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            this.setParameter((Object)objectArray[i].toString(), objectArray[i + 1]);
        }
    }

    public long getPostFooterSize() {
        return this.boundaryNumBytes() + 2L + this.newlineNumBytes() + this.newlineNumBytes();
    }

    private InputStream doPost() throws IOException {
        this.boundary();
        this.writeln("--");
        this.os.close();
        return this.connection.getInputStream();
    }

    public InputStream post() throws IOException {
        this.postCookies();
        return this.doPost();
    }

    public InputStream post(Map map) throws IOException {
        this.postCookies();
        this.setParameters(map);
        return this.doPost();
    }

    public InputStream post(Object ... objectArray) throws IOException {
        this.postCookies();
        this.setParameters(objectArray);
        return this.doPost();
    }

    public InputStream post(Map map, Map map2) throws IOException {
        this.setCookies(map);
        this.postCookies();
        this.setParameters(map2);
        return this.doPost();
    }

    public InputStream post(String string, Map map) throws IOException {
        this.setCookies(string);
        this.postCookies();
        this.setParameters(map);
        return this.doPost();
    }

    public InputStream post(String[] stringArray, Object[] objectArray) throws IOException {
        this.setCookies(stringArray);
        this.postCookies();
        this.setParameters(objectArray);
        return this.doPost();
    }

    public static InputStream post(URL uRL, Map map) throws IOException {
        return new ClientHttpRequest(uRL).post(map);
    }

    public static InputStream post(URL uRL, Object[] objectArray) throws IOException {
        return new ClientHttpRequest(uRL).post(objectArray);
    }

    public static InputStream post(URL uRL, Map map, Map map2) throws IOException {
        return new ClientHttpRequest(uRL).post(map, map2);
    }

    public static InputStream post(URL uRL, String[] stringArray, Object[] objectArray) throws IOException {
        return new ClientHttpRequest(uRL).post(stringArray, objectArray);
    }

    static {
        try {
            UTF_8 = Charset.forName("UTF8");
        }
        catch (Exception exception) {
            InternalUtils.log("jtwitter", "No utf8 charset: " + exception);
        }
        random = new Random();
    }
}

