/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONObject;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import winterwell.jtwitter.InternalUtils;

public class Webhooks {

    public static class WebhookEvent
    extends FromJson {
        public BigInteger for_user_id;
        public JSONArray tweet_create_events;
        public JSONArray tweet_delete_events;
        public JSONArray direct_message_events;
        public JSONArray favorite_events;
        public JSONArray follow_events;
        public JSONArray block_events;
        public JSONArray mute_events;
        public JSONArray user_event;
        public JSONArray direct_message_indicate_typing_events;
        public JSONArray direct_message_mark_read_events;
        public JSONObject users;

        public WebhookEvent(JSONObject jSONObject) {
            this.for_user_id = new BigInteger(jSONObject.getString("for_user_id"));
            this.tweet_create_events = jSONObject.optJSONArray("tweet_create_events");
            this.tweet_delete_events = jSONObject.optJSONArray("tweet_delete_events");
            this.direct_message_events = jSONObject.optJSONArray("direct_message_events");
            this.favorite_events = jSONObject.optJSONArray("favorite_events");
            this.follow_events = jSONObject.optJSONArray("follow_events");
            this.block_events = jSONObject.optJSONArray("block_events");
            this.mute_events = jSONObject.optJSONArray("mute_events");
            this.user_event = jSONObject.optJSONArray("user_event");
            this.direct_message_indicate_typing_events = jSONObject.optJSONArray("direct_message_indicate_typing_events");
            this.direct_message_mark_read_events = jSONObject.optJSONArray("direct_message_mark_read_events");
            this.users = jSONObject.optJSONObject("users");
        }
    }

    public static class SubscriptionsCount
    extends FromJson {
        public String account_name;
        public Integer subscriptions_count;

        public SubscriptionsCount(JSONObject jSONObject) {
            this.account_name = jSONObject.getString("account_name");
            this.subscriptions_count = jSONObject.getInt("subscriptions_count");
        }
    }

    public static class Subscription
    extends FromJson {
        public BigInteger user_id;

        public Subscription(JSONObject jSONObject) {
            this.user_id = new BigInteger(jSONObject.getString("user_id"));
        }
    }

    public static class SubscriptionList
    extends FromJson {
        public String environment;
        public BigInteger application_id;
        public List<Subscription> subscriptions;

        public SubscriptionList(JSONObject jSONObject) {
            this.environment = jSONObject.getString("environment");
            this.application_id = new BigInteger(jSONObject.getString("application_id"));
            this.subscriptions = new ArrayList<Subscription>();
            JSONArray jSONArray = jSONObject.getJSONArray("subscriptions");
            for (JSONObject jSONObject2 : jSONArray) {
                if (!(jSONObject2 instanceof JSONObject)) continue;
                this.subscriptions.add(new Subscription(jSONObject2));
            }
        }
    }

    public static class Webhook
    extends FromJson {
        public BigInteger id;
        public String url;
        public Boolean valid;
        public Date created_timestamp;

        public Webhook(JSONObject jSONObject) {
            this.id = new BigInteger(jSONObject.getString("id"));
            this.url = jSONObject.getString("url");
            this.valid = jSONObject.getBoolean("valid");
            this.created_timestamp = InternalUtils.parseDate(jSONObject.getString("created_timestamp"));
        }
    }

    public static class Environment
    extends FromJson {
        public String environment_name;
        public List<Webhook> webhooks;

        public Environment(JSONObject jSONObject) {
            this.environment_name = jSONObject.getString("environment_name");
            this.webhooks = new ArrayList<Webhook>();
            JSONArray jSONArray = jSONObject.getJSONArray("webhooks");
            for (JSONObject jSONObject2 : jSONArray) {
                if (!(jSONObject2 instanceof JSONObject)) continue;
                this.webhooks.add(new Webhook(jSONObject2));
            }
        }
    }

    public static class WebhookList
    extends FromJson {
        public List<Environment> environments = new ArrayList<Environment>();

        public WebhookList(JSONObject jSONObject) {
            JSONArray jSONArray = jSONObject.getJSONArray("environments");
            for (JSONObject jSONObject2 : jSONArray) {
                if (!(jSONObject2 instanceof JSONObject)) continue;
                this.environments.add(new Environment(jSONObject2));
            }
        }
    }

    private static abstract class FromJson {
        private FromJson() {
        }

        public String toString() {
            JSONObject jSONObject = new JSONObject();
            for (Field field : this.getClass().getDeclaredFields()) {
                try {
                    jSONObject.put(field.getName(), field.get(this));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return jSONObject.toString();
        }
    }
}

