/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import winterwell.jtwitter.AStream;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Message;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;

public class UserStream
extends AStream {
    private boolean withFollowings;
    private boolean allReplies;
    private static final ConcurrentHashMap<String, AStream> user2stream = new ConcurrentHashMap();

    public UserStream(Twitter twitter) {
        super(twitter);
    }

    @Override
    HttpURLConnection connect2() throws IOException {
        InternalUtils.log(this.LOGTAG, "connect2()... " + this);
        this.connect3_rateLimit();
        String string = "https://userstream.twitter.com/1.1/user.json?delimited=length";
        Map map = InternalUtils.asMap("with", this.withFollowings ? "followings" : "user");
        if (this.allReplies) {
            map.put("replies", "all");
        }
        HttpURLConnection httpURLConnection = this.client.connect(string, map, true);
        return httpURLConnection;
    }

    private void connect3_rateLimit() {
        if (this.jtwit.getScreenName() == null) {
            return;
        }
        AStream aStream = user2stream.get(this.jtwit.getScreenName());
        if (aStream != null && aStream.isConnected()) {
            throw new TwitterException.TooManyLogins("One account, one UserStream");
        }
        if (user2stream.size() > 500) {
            user2stream.clear();
        }
        user2stream.put(this.jtwit.getScreenName(), this);
    }

    @Override
    int fillInOutages2(Twitter twitter, AStream.Outage outage) throws UnsupportedOperationException, TwitterException {
        int n = 0;
        List<Twitter.ITweet> list = twitter.getMentions();
        InternalUtils.log(this.LOGTAG, "fillIn mentions " + twitter.getSinceId() + ": " + list.size());
        for (Status object : list) {
            if (this.tweets.contains(object)) continue;
            this.tweets.add(object);
            ++n;
        }
        if (this.withFollowings) {
            twitter.setMaxResults(100);
            list = twitter.getHomeTimeline();
            InternalUtils.log(this.LOGTAG, "fillIn from-you " + twitter.getSinceId() + ": " + list.size());
            for (Status status : list) {
                if (this.tweets.contains(status)) continue;
                this.tweets.add(status);
                ++n;
            }
            twitter.setMaxResults(100000);
        } else {
            list = twitter.getUserTimeline(twitter.getScreenName());
            InternalUtils.log(this.LOGTAG, "fillIn from-you " + twitter.getSinceId() + ": " + list.size());
            for (Status status : list) {
                if (this.tweets.contains(status)) continue;
                this.tweets.add(status);
                ++n;
            }
        }
        twitter.setSinceId(InternalUtils.addTimeToStatusId(outage.sinceDMId, -5000L));
        twitter.setUntilId(InternalUtils.addTimeToStatusId(outage.untilDMId, 5000L));
        twitter.setMaxResults(100000);
        list = twitter.getDirectMessages();
        Object object = "";
        for (Message message : list) {
            if (message == null) continue;
            object = (String)object + message.getId() + " ";
        }
        InternalUtils.log(this.LOGTAG, "fillIn DMs " + twitter.getSinceId() + ": " + list.size() + " " + (String)object);
        for (Twitter.ITweet iTweet : list) {
            if (this.tweets.contains(iTweet)) continue;
            this.tweets.add(iTweet);
            ++n;
        }
        return n;
    }

    public Collection<Number> getFriends() {
        return this.friends;
    }

    public void setWithFollowings(boolean bl) {
        assert (!this.isConnected());
        this.withFollowings = bl;
    }

    public void setAllReplies(boolean bl) {
        assert (!this.isConnected());
        this.allReplies = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("UserStream");
        stringBuilder.append("[" + this.jtwit.getScreenNameIfKnown());
        if (this.withFollowings) {
            stringBuilder.append(" +followings");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

