/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Place;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;

public final class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Date createdAt;
    public final String description;
    public final int favoritesCount;
    private final Boolean followedByYou;
    public int followersCount;
    private final Boolean followingYou;
    public final boolean followRequestSent;
    public final int friendsCount;
    public final Long id;
    String lang;
    public final int listedCount;
    public final String location;
    public final String name;
    public final boolean notifications;
    private Place place;
    public final String profileBackgroundColor;
    public final URI profileBackgroundImageUrl;
    public final boolean profileBackgroundTile;
    public URI profileImageUrl;
    public URI profileImageUrlHttps;
    public final String profileLinkColor;
    public final String profileSidebarBorderColor;
    public final String profileSidebarFillColor;
    public final String profileTextColor;
    public final boolean protectedUser;
    public final String screenName;
    public final Status status;
    public final int statusesCount;
    public final String timezone;
    public final double timezoneOffSet;
    public final boolean verified;
    public final URI website;

    static List<User> getUsers(String string) throws TwitterException {
        if (string.trim().equals("")) {
            return Collections.emptyList();
        }
        try {
            JSONArray jSONArray = new JSONArray(string);
            return User.getUsers2(jSONArray);
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    static List<User> getUsers2(JSONArray jSONArray) throws JSONException {
        ArrayList<User> arrayList = new ArrayList<User>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            User user = new User(jSONObject, null);
            arrayList.add(user);
        }
        return arrayList;
    }

    public String getLang() {
        return this.lang;
    }

    public User(JSONObject jSONObject, Status status) throws TwitterException {
        try {
            Object object;
            this.id = jSONObject.getLong("id");
            this.name = InternalUtils.unencode(InternalUtils.jsonGet("name", jSONObject));
            String string = InternalUtils.jsonGet("screen_name", jSONObject);
            this.screenName = Twitter.CASE_SENSITIVE_SCREENNAMES ? string : string.toLowerCase();
            Object object2 = Status.jsonGetLocn(jSONObject);
            String string2 = this.location = object2 == null ? null : object2.toString();
            if (object2 instanceof Place) {
                this.place = (Place)object2;
            }
            this.lang = InternalUtils.jsonGet("lang", jSONObject);
            this.description = InternalUtils.unencode(InternalUtils.jsonGet("description", jSONObject));
            String string3 = InternalUtils.jsonGet("profile_image_url", jSONObject);
            this.profileImageUrl = string3 == null ? null : InternalUtils.URI(string3);
            String string4 = InternalUtils.jsonGet("profile_image_url_https", jSONObject);
            this.profileImageUrlHttps = string3 == null ? null : InternalUtils.URI(string4);
            String string5 = InternalUtils.jsonGet("url", jSONObject);
            this.website = string5 == null ? null : InternalUtils.URI(string5);
            this.protectedUser = jSONObject.optBoolean("protected");
            this.followersCount = jSONObject.optInt("followers_count");
            this.profileBackgroundColor = InternalUtils.jsonGet("profile_background_color", jSONObject);
            this.profileLinkColor = InternalUtils.jsonGet("profile_link_color", jSONObject);
            this.profileTextColor = InternalUtils.jsonGet("profile_text_color", jSONObject);
            this.profileSidebarFillColor = InternalUtils.jsonGet("profile_sidebar_fill_color", jSONObject);
            this.profileSidebarBorderColor = InternalUtils.jsonGet("profile_sidebar_border_color", jSONObject);
            this.friendsCount = jSONObject.optInt("friends_count");
            String string6 = InternalUtils.jsonGet("created_at", jSONObject);
            this.createdAt = string6 == null ? null : InternalUtils.parseDate(string6);
            this.favoritesCount = jSONObject.optInt("favourites_count");
            String string7 = InternalUtils.jsonGet("utc_offset", jSONObject);
            this.timezoneOffSet = string7 == null ? 0.0 : Double.parseDouble(string7);
            this.timezone = InternalUtils.jsonGet("time_zone", jSONObject);
            string3 = InternalUtils.jsonGet("profile_background_image_url", jSONObject);
            this.profileBackgroundImageUrl = string3 == null ? null : InternalUtils.URI(string3);
            this.profileBackgroundTile = jSONObject.optBoolean("profile_background_tile");
            this.statusesCount = jSONObject.optInt("statuses_count");
            this.notifications = jSONObject.optBoolean("notifications");
            this.verified = jSONObject.optBoolean("verified");
            Object object3 = jSONObject.opt("connections");
            if (object3 instanceof JSONArray) {
                object = (JSONArray)object3;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n = ((JSONArray)object).length();
                for (int i = 0; i < n; ++i) {
                    String string8 = ((JSONArray)object).getString(i);
                    if ("following".equals(string8)) {
                        bl = true;
                        continue;
                    }
                    if ("followed_by".equals(string8)) {
                        bl2 = true;
                        continue;
                    }
                    if (!"following_requested".equals(string8)) continue;
                    bl3 = true;
                }
                this.followedByYou = bl;
                this.followingYou = bl2;
                this.followRequestSent = bl3;
            } else {
                this.followedByYou = InternalUtils.getOptBoolean(jSONObject, "following");
                this.followingYou = InternalUtils.getOptBoolean(jSONObject, "followed_by");
                this.followRequestSent = jSONObject.optBoolean("follow_request_sent");
            }
            this.listedCount = jSONObject.optInt("listed_count", -1);
            this.status = status == null ? ((object = jSONObject.optJSONObject("status")) == null ? null : new Status((JSONObject)object, this)) : status;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(String.valueOf(jSONObject), jSONException);
        }
        catch (NullPointerException nullPointerException) {
            throw new TwitterException(nullPointerException + " from <" + jSONObject + ">, <" + status + ">\n\t" + nullPointerException.getStackTrace()[0] + "\n\t" + nullPointerException.getStackTrace()[1]);
        }
    }

    public User(String string) {
        this(string, null);
    }

    User(String string, Number number) {
        this.id = number == null ? null : Long.valueOf(number.longValue());
        this.name = null;
        if (string != null && !Twitter.CASE_SENSITIVE_SCREENNAMES) {
            string = string.toLowerCase();
        }
        this.screenName = string;
        this.status = null;
        this.location = null;
        this.description = null;
        this.profileImageUrl = null;
        this.website = null;
        this.protectedUser = false;
        this.followersCount = 0;
        this.profileBackgroundColor = null;
        this.profileLinkColor = null;
        this.profileTextColor = null;
        this.profileSidebarFillColor = null;
        this.profileSidebarBorderColor = null;
        this.friendsCount = 0;
        this.createdAt = null;
        this.favoritesCount = 0;
        this.timezoneOffSet = -1.0;
        this.timezone = null;
        this.profileBackgroundImageUrl = null;
        this.profileBackgroundTile = false;
        this.statusesCount = 0;
        this.notifications = false;
        this.verified = false;
        this.followedByYou = null;
        this.followingYou = null;
        this.followRequestSent = false;
        this.listedCount = -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object.getClass() != User.class) {
            return false;
        }
        User user = (User)object;
        if (this.screenName != null && user.screenName != null) {
            return this.screenName.equals(user.screenName);
        }
        if (this.id != null && user.id != null) {
            return this.id == user.id;
        }
        return false;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFavoritesCount() {
        return this.favoritesCount;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public Long getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public Place getPlace() {
        return this.place;
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public URI getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    public URI getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public boolean getProtectedUser() {
        return this.protectedUser;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public double getTimezoneOffSet() {
        return this.timezoneOffSet;
    }

    public URI getWebsite() {
        return this.website;
    }

    public int hashCode() {
        return this.screenName.hashCode();
    }

    public boolean isDummyObject() {
        return this.name == null;
    }

    public Boolean isFollowedByYou() {
        return this.followedByYou;
    }

    public Boolean isFollowingYou() {
        return this.followingYou;
    }

    public boolean isNotifications() {
        return this.notifications;
    }

    public boolean isProfileBackgroundTile() {
        return this.profileBackgroundTile;
    }

    public boolean isProtectedUser() {
        return this.protectedUser;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public String toString() {
        return this.screenName;
    }
}

