/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.MalformedInputException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.RateLimit;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.guts.Base64Encoder;

public class URLConnectionHttpClient
implements Twitter.IHttpClient,
Serializable,
Cloneable {
    private static final int dfltTimeOutMilliSecs = 10000;
    private static final long serialVersionUID = 1L;
    private Map<String, List<String>> headers;
    int minRateLimit;
    protected String name;
    private String password;
    private Map<String, RateLimit> rateLimits = Collections.synchronizedMap(new HashMap());
    boolean retryOnError;
    protected int timeout = 10000;
    private boolean htmlImpliesError = true;
    private boolean gzip = false;
    private transient Map<String, String> postVars;

    @Override
    public boolean isRetryOnError() {
        return this.retryOnError;
    }

    public void setGzip(boolean bl) {
        this.gzip = bl;
    }

    public URLConnectionHttpClient setHtmlImpliesError(boolean bl) {
        this.htmlImpliesError = bl;
        return this;
    }

    public URLConnectionHttpClient() {
        this(null, null);
    }

    public URLConnectionHttpClient(String string, String string2) {
        this.name = string;
        this.password = string2;
        assert (string != null && string2 != null || string == null && string2 == null);
    }

    @Override
    public boolean canAuthenticate() {
        return this.name != null && this.password != null;
    }

    @Override
    public HttpURLConnection connect(String string, Map<String, String> map, boolean bl) throws IOException {
        Object object;
        String string2 = this.checkRateLimit(string);
        if (map != null && map.size() != 0) {
            object = new StringBuilder(string);
            if (string.indexOf(63) == -1) {
                ((StringBuilder)object).append("?");
            } else if (!string.endsWith("&")) {
                ((StringBuilder)object).append("&");
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                String string3 = InternalUtils.encode(entry.getKey());
                assert (!string.contains(string3 + "=")) : string + " " + map;
                ((StringBuilder)object).append(string3 + "=" + InternalUtils.encode(entry.getValue()) + "&");
            }
            string = ((StringBuilder)object).toString();
        }
        object = (HttpURLConnection)new URL(string).openConnection();
        if (bl) {
            this.setAuthentication((URLConnection)object);
        }
        ((URLConnection)object).setRequestProperty("User-Agent", "JTwitter/3.8.6");
        ((URLConnection)object).setRequestProperty("Host", new URL(string).getHost());
        if (this.gzip) {
            ((URLConnection)object).setRequestProperty("Accept-Encoding", "gzip");
        }
        ((URLConnection)object).setDoInput(true);
        ((URLConnection)object).setConnectTimeout(this.timeout);
        ((URLConnection)object).setReadTimeout(this.timeout);
        ((URLConnection)object).setConnectTimeout(this.timeout);
        this.processError((HttpURLConnection)object, string2);
        this.processHeaders((HttpURLConnection)object, string2);
        return object;
    }

    @Override
    public Twitter.IHttpClient copy() {
        return this.clone();
    }

    public URLConnectionHttpClient clone() {
        try {
            URLConnectionHttpClient uRLConnectionHttpClient = (URLConnectionHttpClient)super.clone();
            uRLConnectionHttpClient.name = this.name;
            uRLConnectionHttpClient.password = this.password;
            uRLConnectionHttpClient.gzip = this.gzip;
            uRLConnectionHttpClient.htmlImpliesError = this.htmlImpliesError;
            uRLConnectionHttpClient.setRetryOnError(this.retryOnError);
            uRLConnectionHttpClient.setTimeout(this.timeout);
            uRLConnectionHttpClient.setMinRateLimit(this.minRateLimit);
            uRLConnectionHttpClient.rateLimits = this.rateLimits;
            return uRLConnectionHttpClient;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    protected final void disconnect(HttpURLConnection httpURLConnection) {
        if (httpURLConnection == null) {
            return;
        }
        try {
            httpURLConnection.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getErrorStream(HttpURLConnection httpURLConnection) {
        try {
            return InternalUtils.read(httpURLConnection.getErrorStream());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public String getHeader(String string) {
        if (this.headers == null) {
            return null;
        }
        List<String> list = this.headers.get(string);
        if (list == null) {
            list = this.headers.get(string.toLowerCase());
        }
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    String getName() {
        return this.name;
    }

    @Override
    public Map<String, RateLimit> getRateLimits() {
        return this.rateLimits;
    }

    public Map<String, RateLimit> updateRateLimits() {
        Map<String, String> map = null;
        String string = this.getPage("https://api.twitter.com/1.1/application/rate_limit_status.json", map, true);
        JSONObject jSONObject = new JSONObject(string).getJSONObject("resources");
        Collection<?> collection = jSONObject.getMap().values();
        for (JSONObject jSONObject2 : collection) {
            for (String string2 : jSONObject2.getMap().keySet()) {
                JSONObject jSONObject3 = (JSONObject)jSONObject2.getMap().get(string2);
                RateLimit rateLimit = new RateLimit(jSONObject3);
                this.rateLimits.put(string2, rateLimit);
            }
        }
        return this.getRateLimits();
    }

    @Override
    public final String getPage(String string, Map<String, String> map, boolean bl) throws TwitterException {
        assert (string != null);
        RateLimit.count(string);
        try {
            String string2 = this.getPage2(string, map, bl);
            if (this.htmlImpliesError && (string2.startsWith("<!DOCTYPE html") || string2.startsWith("<html")) && !string.startsWith("https://twitter.com")) {
                String string3 = InternalUtils.stripTags(string2);
                throw new TwitterException.E50X(string3);
            }
            return string2;
        }
        catch (IOException iOException) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(iOException, string);
            }
            try {
                Thread.sleep(500L);
                return this.getPage2(string, map, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(iOException, string);
            }
        }
        catch (TwitterException.E50X e50X) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(e50X, string);
            }
            try {
                Thread.sleep(500L);
                return this.getPage2(string, map, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(e50X, string);
            }
        }
    }

    private TwitterException getPage2_ex(Exception exception, String string) {
        if (exception instanceof TwitterException) {
            return (TwitterException)exception;
        }
        if (exception instanceof SocketTimeoutException) {
            return new TwitterException.Timeout(string);
        }
        if (exception instanceof IOException) {
            return new TwitterException.IO((IOException)exception);
        }
        return new TwitterException(exception);
    }

    private String getPage2(String string, Map<String, String> map, boolean bl) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            String string2;
            httpURLConnection = this.connect(string, map, bl);
            InputStream inputStream = httpURLConnection.getInputStream();
            String string3 = httpURLConnection.getContentEncoding();
            if ("gzip".equals(string3)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            String string4 = string2 = InternalUtils.read(inputStream);
            this.disconnect(httpURLConnection);
            return string4;
        }
        catch (MalformedInputException malformedInputException) {
            try {
                throw new IOException(malformedInputException + " enc:" + httpURLConnection.getContentEncoding());
            }
            catch (Throwable throwable) {
                this.disconnect(httpURLConnection);
                throw throwable;
            }
        }
    }

    @Override
    public RateLimit getRateLimit(Twitter.KRequestType kRequestType) {
        return this.rateLimits.get(kRequestType.rateLimit);
    }

    @Override
    public final String post(String string, Map<String, String> map, boolean bl) throws TwitterException {
        RateLimit.count(string);
        try {
            String string2 = this.post2(string, map, bl);
            return string2;
        }
        catch (TwitterException.E50X e50X) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(e50X, string);
            }
            try {
                Thread.sleep(500L);
                return this.post2(string, map, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(e50X, string);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(socketTimeoutException, string);
            }
            try {
                Thread.sleep(500L);
                return this.post2(string, map, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(socketTimeoutException, string);
            }
        }
        catch (Exception exception) {
            throw this.getPage2_ex(exception, string);
        }
    }

    @Override
    public final String postJSON(String string, JSONObject jSONObject, boolean bl) {
        RateLimit.count(string);
        try {
            String string2 = this.post2(string, jSONObject, bl);
            return string2;
        }
        catch (TwitterException.E50X e50X) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(e50X, string);
            }
            try {
                Thread.sleep(500L);
                return this.post2(string, jSONObject, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(e50X, string);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(socketTimeoutException, string);
            }
            try {
                Thread.sleep(500L);
                return this.post2(string, jSONObject, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(socketTimeoutException, string);
            }
        }
        catch (Exception exception) {
            throw this.getPage2_ex(exception, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post2(String string, Map<String, String> map, boolean bl) throws Exception {
        this.postVars = map;
        HttpURLConnection httpURLConnection = null;
        try {
            String string2;
            httpURLConnection = this.post2_connect(string, map);
            String string3 = string2 = InternalUtils.read(httpURLConnection.getInputStream());
            return string3;
        }
        finally {
            this.disconnect(httpURLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post2(String string, JSONObject jSONObject, boolean bl) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            String string2;
            httpURLConnection = this.post2_connect(string, jSONObject);
            String string3 = string2 = InternalUtils.read(httpURLConnection.getInputStream());
            return string3;
        }
        finally {
            this.disconnect(httpURLConnection);
        }
    }

    @Override
    public HttpURLConnection post2_connect(String string, Map<String, String> map) throws Exception {
        String string2 = this.post2_getPayload(map);
        return this.post2_connect(string, string2);
    }

    @Override
    public HttpURLConnection post2_connect(String string, JSONObject jSONObject) throws Exception {
        String string2 = jSONObject.toString();
        return this.post2_connect(string, string2);
    }

    @Override
    public HttpURLConnection post2_connect(String string, String string2) throws Exception {
        String string3 = this.checkRateLimit(string);
        RateLimit.count(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        this.setAuthentication(httpURLConnection);
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setReadTimeout(this.timeout);
        httpURLConnection.setConnectTimeout(this.timeout);
        httpURLConnection.setRequestProperty("Content-Length", "" + string2.length());
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(string2.getBytes());
        InternalUtils.close(outputStream);
        this.processError(httpURLConnection, string3);
        this.processHeaders(httpURLConnection, string3);
        return httpURLConnection;
    }

    protected String checkRateLimit(String string) {
        String string2 = RateLimit.getResource(string);
        RateLimit rateLimit = this.rateLimits.get(string2);
        if (rateLimit != null && rateLimit.getRemaining() <= this.minRateLimit && !rateLimit.isOutOfDate()) {
            String string3 = "Pre-emptive rate-limit block for " + rateLimit + " for request " + string;
            if (this.minRateLimit > 0) {
                string3 = string3 + " based on minimum limit " + this.minRateLimit;
            }
            throw new TwitterException.PreEmptiveRateLimit(string3);
        }
        return string2;
    }

    protected String post2_getPayload(Map<String, String> map) {
        Object object;
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (map.size() == 1 && "".equals(object = map.keySet().iterator().next())) {
            String string = InternalUtils.encode(map.get(object));
            return string;
        }
        for (String string : map.keySet()) {
            String string2 = InternalUtils.encode(map.get(string));
            stringBuilder.append(InternalUtils.encode(string));
            stringBuilder.append('=');
            stringBuilder.append(string2);
            stringBuilder.append('&');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    @Override
    public final String delete(String string, boolean bl) throws TwitterException {
        try {
            return this.delete2(string, bl);
        }
        catch (TwitterException.E50X e50X) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(e50X, string);
            }
            try {
                Thread.sleep(500L);
                return this.delete2(string, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(e50X, string);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (!this.retryOnError) {
                throw this.getPage2_ex(socketTimeoutException, string);
            }
            try {
                Thread.sleep(500L);
                return this.delete2(string, bl);
            }
            catch (Exception exception) {
                throw this.getPage2_ex(socketTimeoutException, string);
            }
        }
        catch (Exception exception) {
            throw this.getPage2_ex(exception, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String delete2(String string, boolean bl) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            String string2;
            String string3 = this.checkRateLimit(string);
            RateLimit.count(string);
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("DELETE");
            httpURLConnection.setDoOutput(true);
            this.setAuthentication(httpURLConnection);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setReadTimeout(this.timeout);
            httpURLConnection.setConnectTimeout(this.timeout);
            this.processError(httpURLConnection, string3);
            this.processHeaders(httpURLConnection, string3);
            String string4 = string2 = InternalUtils.read(httpURLConnection.getInputStream());
            this.disconnect(httpURLConnection);
            return string4;
        }
        catch (Throwable throwable) {
            this.disconnect(httpURLConnection);
            throw throwable;
        }
    }

    final void processError(HttpURLConnection httpURLConnection, String string) {
        try {
            int n = httpURLConnection.getResponseCode();
            if (n >= 200 && n <= 206) {
                return;
            }
            URL uRL = httpURLConnection.getURL();
            String string2 = this.processError2_reason(httpURLConnection);
            if (n == 401) {
                if (string2.contains("Basic authentication is not supported")) {
                    throw new TwitterException.UpdateToOAuth();
                }
                throw new TwitterException.E401(string2 + "\n" + uRL + " (" + (this.name == null ? "anonymous" : this.name) + ")");
            }
            if (n == 400 && string2.startsWith("code 215")) {
                throw new TwitterException.E401(string2);
            }
            if (n == 403) {
                this.processError2_403(httpURLConnection, string, uRL, string2);
            }
            if (n == 404) {
                if (string2 != null && string2.contains("deleted")) {
                    throw new TwitterException.SuspendedUser(string2 + "\n" + uRL);
                }
                throw new TwitterException.E404(uRL + " " + string2);
            }
            if (n == 406) {
                throw new TwitterException.E406(string2 + "\n" + this.getName() + " " + uRL);
            }
            if (n == 413) {
                throw new TwitterException.E413(string2 + "\n" + this.getName() + " " + uRL);
            }
            if (n == 416) {
                throw new TwitterException.E416(string2 + "\n" + this.getName() + " " + uRL);
            }
            if (n == 420) {
                throw new TwitterException.TooManyLogins(string2 + "\n" + this.getName() + " " + uRL);
            }
            if (n >= 500 && n < 600) {
                throw new TwitterException.E50X(string2 + "\n" + this.getName() + " " + uRL);
            }
            this.processError2_rateLimit(httpURLConnection, string, n, string2);
            if (n > 299 && n < 400) {
                String string3 = httpURLConnection.getHeaderField("Location");
                throw new TwitterException(n + " " + string2 + " " + uRL + " -> " + string3);
            }
            if (string2 != null && string2.startsWith("code 324: Duration too long")) {
                Matcher matcher = Pattern.compile("maximum:(\\d+)000, actual:(\\d+)000").matcher(string2);
                if (matcher.find()) {
                    String string4 = matcher.group(1);
                    String string5 = matcher.group(2);
                    throw new TwitterException.UploadTooBig("Video: Duration too long. This video is " + string5 + "s, but the maximum is " + string4 + "s.");
                }
                throw new TwitterException.UploadTooBig(string2);
            }
            throw new TwitterException(n + " " + string2 + " " + this.getName() + " " + uRL);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            URL uRL = httpURLConnection.getURL();
            throw new TwitterException.Timeout(this.timeout + "milli-secs for " + this.getName() + " " + uRL);
        }
        catch (ConnectException connectException) {
            URL uRL = httpURLConnection.getURL();
            throw new TwitterException.Timeout(this.getName() + " " + uRL.toString());
        }
        catch (SocketException socketException) {
            throw new TwitterException.E50X(this.getName() + " " + socketException.toString());
        }
        catch (IOException iOException) {
            throw new TwitterException(iOException);
        }
    }

    private String processError2_reason(HttpURLConnection httpURLConnection) throws IOException {
        Map<String, List<String>> map;
        Object object;
        String string = URLConnectionHttpClient.readErrorPage(httpURLConnection);
        if (string != null) {
            try {
                object = new JSONObject(string);
                map = ((JSONObject)object).get("errors");
                if (map instanceof JSONArray) {
                    JSONObject jSONObject = ((JSONArray)((Object)map)).getJSONObject(0);
                    return "code " + jSONObject.get("code") + ": " + jSONObject.getString("message");
                }
                if (map instanceof String) {
                    return (String)((Object)map);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = httpURLConnection.getResponseMessage();
        map = httpURLConnection.getHeaderFields();
        List<String> list = map.get(null);
        if (list != null && !list.isEmpty()) {
            object = (String)object + "\n" + list.get(0);
        }
        if (string != null && !string.isEmpty()) {
            object = (String)object + "\n" + string;
        }
        return object;
    }

    private void processError2_403(HttpURLConnection httpURLConnection, String string, URL uRL, String string2) throws TwitterException {
        String string3;
        String string4 = string3 = this.name == null ? "anon" : this.name;
        if (string2 == null) {
            throw new TwitterException.E403(uRL + " (" + string3 + ")");
        }
        if (string2.startsWith("code 185") || string2.contains("Wow, that's a lot of Twittering!")) {
            this.processHeaders(httpURLConnection, string);
            throw new TwitterException.RateLimit(string2 + " " + this.getName());
        }
        if (string2.contains("too old")) {
            throw new TwitterException.BadParameter(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("suspended")) {
            throw new TwitterException.SuspendedUser(string2 + ": " + this.getName() + "\n" + uRL);
        }
        if (string2.contains("Could not find")) {
            throw new TwitterException.SuspendedUser(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("too recent")) {
            throw new TwitterException.TooRecent(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("code 226")) {
            throw new TwitterException.TooSpammy(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("code 250")) {
            throw new TwitterException.AgeScreen(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("code 326")) {
            throw new TwitterException.SuspendedProfile(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("already requested to follow")) {
            throw new TwitterException.Repetition(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("code 327")) {
            throw new TwitterException.RepeatRetweet(string2 + "\n" + this.getName() + " " + uRL);
        }
        if (string2.contains("duplicate")) {
            throw new TwitterException.Repetition(string2);
        }
        if (string2.contains("unable to follow more people")) {
            throw new TwitterException.FollowerLimit(this.name + " " + string2);
        }
        if (string2.contains("application is not allowed to access")) {
            throw new TwitterException.AccessLevel(this.name + " " + string2);
        }
        if (string2.contains("code 108:")) {
            throw new TwitterException.UserNotFound(uRL + " (" + string3 + ") posted: " + this.postVars);
        }
        if (string2.contains("code 158:")) {
            throw new TwitterException.Repetition(string2);
        }
        if (string2.contains("code 162:")) {
            throw new TwitterException.Blocked(string2, this.postVars == null ? null : this.postVars.get("screen_name"));
        }
        throw new TwitterException.E403(string2 + "\n" + uRL + " (" + string3 + ") posted: " + this.postVars);
    }

    private void processError2_rateLimit(HttpURLConnection httpURLConnection, String string, int n, String string2) {
        boolean bl = string2.contains("Rate limit exceeded");
        if (bl) {
            this.processHeaders(httpURLConnection, string);
            throw new TwitterException.RateLimit(this.getName() + ": " + string2);
        }
        if (n == 400) {
            try {
                String string3 = this.getPage("http://twitter.com/account/rate_limit_status.json", null, this.password != null);
                JSONObject jSONObject = new JSONObject(string3);
                int n2 = jSONObject.getInt("remaining_hits");
                if (n2 < 1) {
                    throw new TwitterException.RateLimit(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void processHeaders(HttpURLConnection httpURLConnection, String string) {
        this.headers = httpURLConnection.getHeaderFields();
        this.updateRateLimits(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static String readErrorPage(HttpURLConnection httpURLConnection) {
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            return null;
        }
        try {
            if ("gzip".equals(httpURLConnection.getHeaderField("Content-Encoding"))) {
                inputStream = new GZIPInputStream(inputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder(8192);
            char[] cArray = new char[8192];
            try {
                int n;
                while ((n = bufferedReader.read(cArray)) != -1) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (IOException iOException) {
                if (stringBuilder.length() == 0) {
                    String string = null;
                    InternalUtils.close(inputStream);
                    return string;
                }
                String string = stringBuilder.toString();
                InternalUtils.close(inputStream);
                return string;
            }
            String string = stringBuilder.toString();
            return string;
            {
                catch (IOException iOException) {
                    stringBuilder = null;
                    return stringBuilder;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    protected void setAuthentication(URLConnection uRLConnection) {
        if (this.name == null || this.password == null) {
            throw new TwitterException.E401("Authentication requested but no authorisation details are set! name: " + this.name);
        }
        String string = this.name + ":" + this.password;
        String string2 = Base64Encoder.encode(string);
        string2 = string2.replace("\r\n", "");
        uRLConnection.setRequestProperty("Authorization", "Basic " + string2);
    }

    public void setMinRateLimit(int n) {
        this.minRateLimit = n;
    }

    @Override
    public void setRetryOnError(boolean bl) {
        this.retryOnError = bl;
    }

    @Override
    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ", password=" + (this.password == null ? "null" : "XXX") + "]";
    }

    void updateRateLimits(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getHeader("X-Rate-Limit-Limit");
        if (string2 == null) {
            return;
        }
        String string3 = this.getHeader("X-Rate-Limit-Remaining");
        String string4 = this.getHeader("X-Rate-Limit-Reset");
        this.rateLimits.put(string, new RateLimit(string2, string3, string4));
    }
}

