/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.jgeoplanet.GeoCodeQuery;
import com.winterwell.jgeoplanet.IGeoCode;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Place;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;

public class Twitter_Geo
implements IGeoCode {
    private double accuracy;
    private final Twitter jtwit;

    Twitter_Geo(Twitter twitter) {
        assert (twitter != null);
        this.jtwit = twitter;
    }

    public List geoSearch(double d, double d2) {
        throw new RuntimeException();
    }

    public List<Place> geoSearch(String string) {
        String string2 = this.jtwit.TWITTER_URL + "/geo/search.json";
        Map map = InternalUtils.asMap("query", string);
        if (this.accuracy != 0.0) {
            map.put("accuracy", String.valueOf(this.accuracy));
        }
        String string3 = this.jtwit.getHttpClient().getPage(string2, map, true);
        try {
            JSONObject jSONObject = new JSONObject(string3);
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            JSONArray jSONArray = jSONObject2.getJSONArray("places");
            ArrayList<Place> arrayList = new ArrayList<Place>(jSONArray.length());
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                Place place = new Place(jSONObject3, this);
                arrayList.add(place);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string3, jSONException);
        }
    }

    public List geoSearchByIP(String string) {
        throw new RuntimeException();
    }

    public List<Place> getTrendRegions() {
        String string = this.jtwit.getHttpClient().getPage(this.jtwit.TWITTER_URL + "/trends/available.json", null, false);
        try {
            JSONArray jSONArray = new JSONArray(string);
            ArrayList<Place> arrayList = new ArrayList<Place>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                Place place = new Place(jSONObject, this);
                arrayList.add(place);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public void setAccuracy(double d) {
        this.accuracy = d;
    }

    @Override
    public Place getPlace(String string) {
        Map<IPlace, Double> map = this.getPlace(new GeoCodeQuery(string));
        if (map.isEmpty()) {
            return null;
        }
        return (Place)InternalUtils.getBest(map);
    }

    @Override
    public Map<IPlace, Double> getPlace(GeoCodeQuery geoCodeQuery) {
        if (geoCodeQuery.desc == null || geoCodeQuery.desc.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        List<Place> list = this.geoSearch(geoCodeQuery.desc);
        if (list.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        if (list.size() == 1) {
            return Collections.singletonMap((IPlace)list.get(0), 0.8);
        }
        return InternalUtils.prefer(geoCodeQuery, list, "city", 0.8);
    }

    @Override
    public Boolean matches(GeoCodeQuery geoCodeQuery, IPlace iPlace) {
        return InternalUtils.geoMatch(geoCodeQuery, iPlace);
    }
}

