/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.OAuthSignpostClient;
import winterwell.jtwitter.RateLimit;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.URLConnectionHttpClient;
import winterwell.jtwitter.User;

public class Twitter_Account {
    public static String COLOR_BG = "profile_background_color";
    public static String COLOR_LINK = "profile_link_color";
    public static String COLOR_SIDEBAR_BORDER = "profile_sidebar_border_color";
    public static String COLOR_SIDEBAR_FILL = "profile_sidebar_fill_color";
    public static String COLOR_TEXT = "profile_text_color";
    private KAccessLevel accessLevel;
    final Twitter jtwit;

    public Twitter_Account(Twitter twitter) {
        assert (twitter.getHttpClient().canAuthenticate()) : twitter;
        this.jtwit = twitter;
    }

    public Map<String, RateLimit> getRateLimits() {
        return ((URLConnectionHttpClient)this.jtwit.getHttpClient()).updateRateLimits();
    }

    public Search createSavedSearch(String string) {
        String string2 = this.jtwit.TWITTER_URL + "saved_searches/create.json";
        Map map = InternalUtils.asMap("query", string);
        String string3 = this.jtwit.getHttpClient().post(string2, map, true);
        try {
            return this.makeSearch(new JSONObject(string3));
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string3, jSONException);
        }
    }

    public Search destroySavedSearch(Long l) {
        String string = this.jtwit.TWITTER_URL + "saved_searches/destroy/" + l + ".json";
        String string2 = this.jtwit.getHttpClient().post(string, null, true);
        try {
            return this.makeSearch(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public KAccessLevel getAccessLevel() {
        if (this.accessLevel != null) {
            return this.accessLevel;
        }
        try {
            this.verifyCredentials();
            return this.accessLevel;
        }
        catch (TwitterException.E401 e401) {
            return KAccessLevel.NONE;
        }
    }

    public List<Search> getSavedSearches() {
        String string = this.jtwit.TWITTER_URL + "saved_searches.json";
        String string2 = this.jtwit.getHttpClient().getPage(string, null, true);
        try {
            JSONArray jSONArray = new JSONArray(string2);
            ArrayList<Search> arrayList = new ArrayList<Search>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                Search search = this.makeSearch(jSONObject);
                arrayList.add(search);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    private Search makeSearch(JSONObject jSONObject) throws JSONException {
        Date date = InternalUtils.parseDate(jSONObject.getString("created_at"));
        Long l = jSONObject.getLong("id");
        String string = jSONObject.getString("query");
        Search search = new Search(l, date, string);
        return search;
    }

    public User setProfile(String string, String string2, String string3, String string4) {
        Map map = InternalUtils.asMap("name", string, "url", string2, "location", string3, "description", string4);
        String string5 = this.jtwit.TWITTER_URL + "/account/update_profile.json";
        String string6 = this.jtwit.getHttpClient().post(string5, map, true);
        return InternalUtils.user(string6);
    }

    public User setProfileDescription(String string) {
        return this.setProfile(null, null, null, string);
    }

    public User setProfileLink(String string) {
        return this.setProfile(null, string, null, null);
    }

    public User setProfileLocation(String string) {
        return this.setProfile(null, null, string, null);
    }

    public User setProfileImage(File file) {
        Map map = InternalUtils.asMap("image", file);
        String string = this.jtwit.TWITTER_URL + "/account/update_profile_image.json";
        String string2 = ((OAuthSignpostClient)this.jtwit.getHttpClient()).postMultipartForm(string, map);
        return InternalUtils.user(string2);
    }

    public void setProfileBanner(File file) {
        Map map = InternalUtils.asMap("banner", file);
        String string = this.jtwit.TWITTER_URL + "/account/update_profile_banner.json";
        ((OAuthSignpostClient)this.jtwit.getHttpClient()).postMultipartForm(string, map);
    }

    public void removeProfileBanner() {
        String string = this.jtwit.TWITTER_URL + "/account/remove_profile_banner.json";
        ((OAuthSignpostClient)this.jtwit.getHttpClient()).post(string, new HashMap<String, String>(), true);
    }

    public User setProfileColors(Map<String, String> map) {
        assert (map.size() != 0);
        String string = this.jtwit.TWITTER_URL + "/account/update_profile_colors.json";
        String string2 = this.jtwit.getHttpClient().post(string, map, true);
        return InternalUtils.user(string2);
    }

    public String toString() {
        return "TwitterAccount[" + this.jtwit.getScreenName() + "]";
    }

    public User verifyCredentials() throws TwitterException.E401 {
        User user;
        String string = this.jtwit.TWITTER_URL + "/account/verify_credentials.json";
        String string2 = this.jtwit.getHttpClient().getPage(string, null, true);
        Twitter.IHttpClient iHttpClient = this.jtwit.getHttpClient();
        String string3 = iHttpClient.getHeader("X-Access-Level");
        if (string3 != null) {
            if ("read".equals(string3)) {
                this.accessLevel = KAccessLevel.READ_ONLY;
            }
            if ("read-write".equals(string3)) {
                this.accessLevel = KAccessLevel.READ_WRITE;
            }
            if ("read-write-directmessages".equals(string3)) {
                this.accessLevel = KAccessLevel.READ_WRITE_DM;
            }
        }
        this.jtwit.self = user = InternalUtils.user(string2);
        return user;
    }

    public static class Search {
        private Date createdAt;
        private Long id;
        private String query;

        public Search(Long l, Date date, String string) {
            this.id = l;
            this.createdAt = date;
            this.query = string;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Long getId() {
            return this.id;
        }

        public String getText() {
            return this.query;
        }
    }

    public static enum KAccessLevel {
        NONE,
        READ_ONLY,
        READ_WRITE,
        READ_WRITE_DM;

    }
}

