/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.User;

public class TwitterList
extends AbstractList<User> {
    private boolean _private;
    private long cursor = -1L;
    private String description;
    private final Twitter.IHttpClient http;
    private Number id;
    private final Twitter jtwit;
    private int memberCount = -1;
    private String name;
    private User owner;
    private String slug;
    private int subscriberCount;
    private final List<User> users = new ArrayList<User>();

    public static TwitterList get(String string, String string2, Twitter twitter) {
        return new TwitterList(string, string2, twitter);
    }

    public static TwitterList get(Number number, Twitter twitter) {
        return new TwitterList(number, twitter);
    }

    TwitterList(JSONObject jSONObject, Twitter twitter) throws JSONException {
        this.jtwit = twitter;
        this.http = twitter.getHttpClient();
        this.init2(jSONObject);
    }

    @Deprecated
    public TwitterList(String string, String string2, Twitter twitter) {
        assert (string != null && string2 != null && twitter != null);
        this.jtwit = twitter;
        this.owner = new User(string);
        this.name = string2;
        this.slug = string2;
        this.http = twitter.getHttpClient();
        this.init();
    }

    public TwitterList(String string, Twitter twitter, boolean bl, String string2) {
        assert (string != null && twitter != null);
        this.jtwit = twitter;
        String string3 = twitter.getScreenName();
        assert (string3 != null);
        this.name = string;
        this.slug = string;
        this.http = twitter.getHttpClient();
        String string4 = twitter.TWITTER_URL + "/lists/create.json";
        Map map = InternalUtils.asMap("name", string, "mode", bl ? "public" : "private", "description", string2);
        String string5 = this.http.post(string4, map, true);
        try {
            JSONObject jSONObject = new JSONObject(string5);
            this.init2(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException("Could not parse response: " + jSONException);
        }
    }

    public TwitterList(Number number, Twitter twitter) {
        assert (number != null && twitter != null);
        this.jtwit = twitter;
        this.id = number;
        this.http = twitter.getHttpClient();
        this.init();
    }

    @Override
    public boolean add(User user) {
        if (this.users.contains(user)) {
            return false;
        }
        String string = this.jtwit.TWITTER_URL + "/lists/members/create.json";
        Map<String, String> map = this.getListVars();
        map.put("screen_name", user.screenName);
        String string2 = this.http.post(string, map, true);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.memberCount = jSONObject.getInt("member_count");
            this.users.add(user);
            return true;
        }
        catch (JSONException jSONException) {
            throw new TwitterException("Could not parse response: " + jSONException);
        }
    }

    @Override
    public boolean addAll(Collection<? extends User> collection) {
        ArrayList<? extends User> arrayList = new ArrayList<User>(collection);
        arrayList.removeAll(this.users);
        if (arrayList.size() == 0) {
            return false;
        }
        String string = this.jtwit.TWITTER_URL + "/lists/members/create_all.json";
        Map<String, String> map = this.getListVars();
        int n = 100;
        for (int i = 0; i < this.users.size(); i += n) {
            int n2 = i + n;
            String string2 = InternalUtils.join(arrayList, i, n2);
            map.put("screen_name", string2);
            String string3 = this.http.post(string, map, true);
            try {
                JSONObject jSONObject = new JSONObject(string3);
                this.memberCount = jSONObject.getInt("member_count");
                continue;
            }
            catch (JSONException jSONException) {
                throw new TwitterException("Could not parse response: " + jSONException);
            }
        }
        return true;
    }

    public void delete() {
        String string = this.jtwit.TWITTER_URL + "/lists/destroy.json";
        this.http.post(string, this.getListVars(), true);
    }

    @Override
    public User get(int n) {
        String string = this.jtwit.TWITTER_URL + "/lists/members.json";
        Map<String, String> map = this.getListVars();
        while (this.users.size() < n + 1 && this.cursor != 0L) {
            map.put("cursor", Long.toString(this.cursor));
            String string2 = this.http.getPage(string, map, true);
            try {
                JSONObject jSONObject = new JSONObject(string2);
                JSONArray jSONArray = (JSONArray)jSONObject.get("users");
                List<User> list = User.getUsers(jSONArray.toString());
                this.users.addAll(list);
                this.cursor = new Long(jSONObject.getString("next_cursor"));
            }
            catch (JSONException jSONException) {
                throw new TwitterException("Could not parse user list" + jSONException);
            }
        }
        return this.users.get(n);
    }

    public String getDescription() {
        this.init();
        return this.description;
    }

    private Map<String, String> getListVars() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.id != null) {
            hashMap.put("list_id", (String)((Object)this.id));
            return hashMap;
        }
        hashMap.put("owner_screen_name", this.owner.screenName);
        hashMap.put("slug", this.slug);
        return hashMap;
    }

    public Number getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public User getOwner() {
        return this.owner;
    }

    public List<Status> getStatuses() throws TwitterException {
        Map<String, String> map = this.getListVars();
        this.jtwit.addStandardishParameters(map);
        String string = this.jtwit.TWITTER_URL + "/lists/statuses.json";
        return this.jtwit.getStatuses(string, map, true);
    }

    public int getSubscriberCount() {
        this.init();
        return this.subscriberCount;
    }

    public List<User> getSubscribers() {
        String string = this.jtwit.TWITTER_URL + "/lists/subscribers.json";
        Map<String, String> map = this.getListVars();
        String string2 = this.http.getPage(string, map, true);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            JSONArray jSONArray = jSONObject.getJSONArray("users");
            return User.getUsers2(jSONArray);
        }
        catch (JSONException jSONException) {
            throw new TwitterException("Could not parse response: " + jSONException);
        }
    }

    private void init() {
        if (this.memberCount != -1) {
            return;
        }
        String string = this.jtwit.TWITTER_URL + "/lists/show.json";
        Map<String, String> map = this.getListVars();
        String string2 = this.http.getPage(string, map, true);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.init2(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException("Could not parse response: " + jSONException);
        }
    }

    private void init2(JSONObject jSONObject) throws JSONException {
        this.memberCount = jSONObject.getInt("member_count");
        this.subscriberCount = jSONObject.getInt("subscriber_count");
        this.name = jSONObject.getString("name");
        this.slug = jSONObject.getString("slug");
        this.id = new BigInteger(jSONObject.getString("id_str"));
        this._private = "private".equals(jSONObject.optString("mode"));
        this.description = jSONObject.optString("description");
        JSONObject jSONObject2 = jSONObject.getJSONObject("user");
        this.owner = new User(jSONObject2, null);
    }

    public boolean isPrivate() {
        this.init();
        return this._private;
    }

    @Override
    public boolean remove(Object object) {
        try {
            User user = (User)object;
            String string = this.jtwit.TWITTER_URL + "/lists/members/destroy.json";
            Map<String, String> map = this.getListVars();
            map.put("screen_name", user.screenName);
            String string2 = this.http.post(string, map, true);
            JSONObject jSONObject = new JSONObject(string2);
            this.memberCount = jSONObject.getInt("member_count");
            this.users.remove(user);
            return true;
        }
        catch (JSONException jSONException) {
            throw new TwitterException("Could not parse response: " + jSONException);
        }
    }

    public void setDescription(String string) {
        String string2 = this.jtwit.TWITTER_URL + "/lists/update.json";
        Map<String, String> map = this.getListVars();
        map.put("description", string);
        String string3 = this.http.getPage(string2, map, true);
        try {
            JSONObject jSONObject = new JSONObject(string3);
            this.init2(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException("Could not parse response: " + jSONException);
        }
    }

    public void setPrivate(boolean bl) {
        String string = this.jtwit.TWITTER_URL + "/lists/update.json";
        Map<String, String> map = this.getListVars();
        map.put("mode", bl ? "private" : "public");
        String string2 = this.http.getPage(string, map, true);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.init2(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException("Could not parse response: " + jSONException);
        }
    }

    @Override
    public int size() {
        this.init();
        return this.memberCount;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.owner + "." + this.name + "]";
    }
}

