/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import winterwell.jtwitter.AStream;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterEvent;

final class StreamGobbler
extends Thread {
    Exception ex;
    int forgotten;
    private ArrayList<String> jsons = new ArrayList();
    volatile boolean stopFlag;
    final AStream stream;

    public StreamGobbler(AStream aStream) {
        this.setDaemon(true);
        this.stream = aStream;
    }

    protected void finalize() throws Throwable {
        if (this.stream != null) {
            InternalUtils.close(this.stream.stream);
        }
    }

    public void pleaseStop() {
        if (this.stream != null) {
            InternalUtils.close(this.stream.stream);
        }
        this.stopFlag = true;
    }

    public synchronized String[] popJsons() {
        String[] stringArray = this.jsons.toArray(new String[this.jsons.size()]);
        this.jsons = new ArrayList();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJson(BufferedReader bufferedReader, int n) throws IOException {
        assert (n > 0);
        char[] cArray = new char[n];
        int n2 = 0;
        while (n > 0) {
            int n3 = bufferedReader.read(cArray, n2, n);
            if (n3 == -1) {
                throw new IOException("end of stream");
            }
            n2 += n3;
            n -= n3;
        }
        String string = new String(cArray);
        if (!this.stream.listenersOnly) {
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                this.jsons.add(string);
                this.forgotten += AStream.forgetIfFull(this.jsons);
            }
        }
        this.readJson2_notifyListeners(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJson2_notifyListeners(String string) {
        if (this.stream.listeners.size() == 0) {
            return;
        }
        List<AStream.IListen> list = this.stream.listeners;
        synchronized (list) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                Object object = AStream.read3_parse(jSONObject, this.stream.jtwit);
                for (AStream.IListen iListen : this.stream.listeners) {
                    try {
                        boolean bl = object instanceof Twitter.ITweet ? iListen.processTweet((Twitter.ITweet)object) : (object instanceof TwitterEvent ? iListen.processEvent((TwitterEvent)object) : iListen.processSystemEvent((Object[])object));
                        if (bl) continue;
                        break;
                    }
                    catch (Exception exception) {
                        InternalUtils.log(this.stream.LOGTAG, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                InternalUtils.log(this.stream.LOGTAG, throwable);
            }
        }
    }

    private int readLength(BufferedReader bufferedReader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = bufferedReader.read()) == -1) {
                throw new IOException("end of stream " + this);
            }
            char c = (char)n;
            if (c == '\n' || c == '\r') {
                if (stringBuilder.length() != 0) break;
                continue;
            }
            assert (Character.isDigit(c)) : c;
            assert (stringBuilder.length() < 10) : stringBuilder;
            stringBuilder.append(c);
        }
        return Integer.valueOf(stringBuilder.toString());
    }

    @Override
    public void run() {
        while (!this.stopFlag) {
            assert (this.stream.stream != null) : this.stream;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.stream.stream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while (!this.stopFlag) {
                    int n = this.readLength(bufferedReader);
                    this.readJson(bufferedReader, n);
                }
            }
            catch (Exception exception) {
                if (this.stopFlag) {
                    return;
                }
                this.ex = exception;
                this.stream.addSysEvent(new Object[]{"exception", this.ex});
                InternalUtils.log(this.stream.LOGTAG, this + " gobbler.run() exception: " + InternalUtils.str(this.ex));
                if (!this.stream.autoReconnect) {
                    return;
                }
                try {
                    this.stream.reconnectFromGobblerThread();
                    assert (this.stream.stream != null) : this.stream;
                }
                catch (Exception exception2) {
                    InternalUtils.log(this.stream.LOGTAG, this + " gobbler.run() reconnect exception: now: " + InternalUtils.str(exception2) + " was: " + this.ex);
                    this.ex = exception2;
                    return;
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.getName() + "[" + this.jsons.size() + "]";
    }
}

