/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONObject;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.TwitterException;

public final class RateLimit {
    public static final String RES_STREAM_USER = "/stream/user";
    public static final String RES_STREAM_KEYWORD = "/stream/keyword";
    public static final String RES_USERS_BULK_SHOW = "/users/lookup";
    public static final String RES_USERS_SHOW1 = "/users/show";
    public static final String RES_USER_TIMELINE = "/statuses/user_timeline";
    public static final String RES_HOME_TIMELINE = "/statuses/home_timeline";
    public static final String RES_MENTIONS = "/statuses/mentions_timeline";
    public static final String RES_SEARCH = "/search/tweets";
    public static final String RES_STATUS_SHOW = "/statuses/show";
    public static final String RES_USERS_SEARCH = "/users/search";
    public static final String RES_FRIENDSHIPS_SHOW = "/friendships/show";
    public static final String RES_TRENDS = "/trends/place";
    public static final String RES_LISTS_SHOW = "/lists/show";
    private String limit;
    private String remaining;
    private String reset;
    private transient Date _reset;
    static ConcurrentHashMap<String, Long> usage;

    public RateLimit(String string, String string2, String string3) {
        this.limit = string;
        this.remaining = string2;
        this.reset = string3;
    }

    RateLimit(JSONObject jSONObject) {
        this(jSONObject.getString("limit"), jSONObject.getString("remaining"), jSONObject.getString("reset"));
    }

    public int getLimit() {
        return Integer.valueOf(this.limit);
    }

    public int getRemaining() {
        return Integer.valueOf(this.remaining);
    }

    public Date getReset() {
        if (this._reset == null) {
            this._reset = InternalUtils.parseDate(this.reset);
        }
        return this._reset;
    }

    public boolean isOutOfDate() {
        return this.getReset().getTime() < System.currentTimeMillis();
    }

    public String toString() {
        return this.remaining;
    }

    public void waitForReset() {
        Long l = Long.valueOf(this.reset);
        long l2 = System.currentTimeMillis();
        long l3 = l - l2;
        if (l3 < 0L) {
            return;
        }
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            throw new TwitterException(interruptedException);
        }
    }

    public static void setTrackAPIUsage(boolean bl) {
        if (!bl) {
            usage = null;
            return;
        }
        if (usage != null) {
            return;
        }
        usage = new ConcurrentHashMap();
    }

    static void count(String string) {
        if (usage == null) {
            return;
        }
        int n = string.indexOf("?");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("/1/")) != -1) {
            string = string.substring(n + 3);
        }
        string = string.replaceAll("\\d+", "");
        for (int i = 0; i < 100; ++i) {
            boolean bl;
            Long l = usage.get(string);
            if (l == null) {
                Long l2 = usage.putIfAbsent(string, 1L);
                bl = l2 == null;
            } else {
                long l3 = l + 1L;
                bl = usage.replace(string, l, l3);
            }
            if (bl) break;
        }
    }

    public static ConcurrentHashMap<String, Long> getAPIUsageStats() {
        return usage;
    }

    public static String getResource(String string) {
        if (!string.startsWith("https://api.twitter.com/1.1")) {
            return null;
        }
        int n = "https://api.twitter.com/1.1".length();
        int n2 = string.indexOf(".json", n);
        if (n2 == -1) {
            return null;
        }
        if (string.substring(n, n2).startsWith("/direct_messages/events")) {
            return string.substring(n, n2);
        }
        int n3 = string.indexOf("/", n + 1);
        if (n3 == -1 || n3 > n2) {
            return string.substring(n, n2);
        }
        int n4 = string.indexOf("/", n3 + 1);
        if (n4 == -1 || n4 > n2) {
            return string.substring(n, n2);
        }
        return string.substring(n, n4);
    }
}

