/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import oauth.signpost.AbstractOAuthProvider;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.basic.HttpURLConnectionRequestAdapter;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.SigningStrategy;
import winterwell.jtwitter.FlickrOAuthProvider;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.SimpleOAuthConsumer;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.URLConnectionHttpClient;
import winterwell.jtwitter.guts.ClientHttpRequest;

public class OAuthSignpostClient
extends URLConnectionHttpClient
implements Twitter.IHttpClient,
Serializable {
    public static final String JTWITTER_OAUTH_KEY = "Cz8ZLgitPR2jrQVaD6ncw";
    public static final String JTWITTER_OAUTH_SECRET = "9FFYaWJSvQ6Yi5tctN30eN6DnXWmdw0QgJMl7V6KGI";
    private static final long serialVersionUID = 1L;
    private String accessToken;
    private String accessTokenSecret;
    private String callbackUrl;
    private OAuthConsumer consumer;
    private String consumerKey;
    private String consumerSecret;
    private AbstractOAuthProvider provider;

    public OAuthConsumer getConsumer() {
        return this.consumer;
    }

    public final String postMultipartForm(String string, Map<String, ?> map) throws TwitterException {
        String string2 = this.checkRateLimit(string);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setReadTimeout(this.timeout);
            httpURLConnection.setConnectTimeout(this.timeout);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            final String string3 = this.post2_getPayload(hashMap);
            HttpURLConnectionRequestAdapter httpURLConnectionRequestAdapter = new HttpURLConnectionRequestAdapter(httpURLConnection){

                public InputStream getMessagePayload() throws IOException {
                    return new StringBufferInputStream(string3);
                }
            };
            SimpleOAuthConsumer simpleOAuthConsumer = new SimpleOAuthConsumer(this.consumerKey, this.consumerSecret);
            simpleOAuthConsumer.setTokenWithSecret(this.accessToken, this.accessTokenSecret);
            AuthorizationHeaderSigningStrategy authorizationHeaderSigningStrategy = new AuthorizationHeaderSigningStrategy();
            simpleOAuthConsumer.setSigningStrategy((SigningStrategy)authorizationHeaderSigningStrategy);
            simpleOAuthConsumer.sign((HttpRequest)httpURLConnectionRequestAdapter);
            ClientHttpRequest clientHttpRequest = new ClientHttpRequest(httpURLConnection);
            InputStream inputStream = clientHttpRequest.post(map);
            this.processError(httpURLConnection, string2);
            this.processHeaders(httpURLConnection, string2);
            return InternalUtils.read(inputStream);
        }
        catch (TwitterException twitterException) {
            throw twitterException;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new TwitterException.Timeout(this.timeout + "milli-secs for " + string);
        }
        catch (ConnectException connectException) {
            throw new TwitterException.Timeout(string.toString());
        }
        catch (SocketException socketException) {
            throw new TwitterException.E50X(socketException.toString());
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().contains("HTTP response code: 500")) {
                throw new TwitterException.E50X(iOException.toString());
            }
            if (httpURLConnection != null) {
                this.processError(httpURLConnection, string2);
            }
            throw new TwitterException(iOException);
        }
        catch (Exception exception) {
            throw new TwitterException(exception);
        }
    }

    private static final DefaultOAuthProvider FOURSQUARE_PROVIDER() {
        return new DefaultOAuthProvider("http://foursquare.com/oauth/request_token", "http://foursquare.com/oauth/access_token", "http://foursquare.com/oauth/authorize");
    }

    private static final DefaultOAuthProvider LINKEDIN_PROVIDER() {
        return new DefaultOAuthProvider("https://api.linkedin.com/uas/oauth/requestToken", "https://api.linkedin.com/uas/oauth/accessToken", "https://www.linkedin.com/uas/oauth/authorize");
    }

    private static final FlickrOAuthProvider FLICKR_PROVIDER() {
        return new FlickrOAuthProvider("https://www.flickr.com/services/oauth/request_token", "https://www.flickr.com/services/oauth/access_token", "https://www.flickr.com/services/oauth/authorize");
    }

    public static String askUser(String string) {
        try {
            Class<?> clazz = Class.forName("javax.swing.JOptionPane");
            Method method = clazz.getMethod("showInputDialog", Object.class);
            return (String)method.invoke(null, string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public AbstractOAuthProvider getProvider() {
        return this.provider;
    }

    public OAuthSignpostClient(String string, String string2, String string3) {
        assert (string != null && string2 != null && string3 != null);
        this.consumerKey = string;
        this.consumerSecret = string2;
        this.callbackUrl = string3;
        this.init();
    }

    public OAuthSignpostClient(String string, String string2, String string3, String string4) {
        this.consumerKey = string.toString();
        this.consumerSecret = string2.toString();
        this.accessToken = string3.toString();
        this.accessTokenSecret = string4.toString();
        this.init();
    }

    @Deprecated
    public void authorizeDesktop() {
        URI uRI = this.authorizeUrl();
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getMethod("browse", URI.class);
            method2.invoke(object, uRI);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public URI authorizeUrl() {
        try {
            String string = this.provider.retrieveRequestToken(this.consumer, this.callbackUrl, new String[0]);
            return new URI(string);
        }
        catch (Exception exception) {
            throw new TwitterException(exception);
        }
    }

    public String signInUrl() {
        try {
            String string = this.provider.retrieveRequestToken(this.consumer, this.callbackUrl, new String[0]);
            string = string.replace("authorize", "authenticate");
            return string;
        }
        catch (Exception exception) {
            throw new TwitterException(exception);
        }
    }

    @Override
    public boolean canAuthenticate() {
        return this.consumer.getToken() != null;
    }

    @Override
    public Twitter.IHttpClient copy() {
        return this.clone();
    }

    @Override
    public URLConnectionHttpClient clone() {
        OAuthSignpostClient oAuthSignpostClient = (OAuthSignpostClient)super.clone();
        oAuthSignpostClient.consumerKey = this.consumerKey;
        oAuthSignpostClient.consumerSecret = this.consumerSecret;
        oAuthSignpostClient.accessToken = this.accessToken;
        oAuthSignpostClient.accessTokenSecret = this.accessTokenSecret;
        oAuthSignpostClient.callbackUrl = this.callbackUrl;
        oAuthSignpostClient.init();
        return oAuthSignpostClient;
    }

    public String[] getAccessToken() {
        if (this.accessToken == null) {
            return null;
        }
        return new String[]{this.accessToken, this.accessTokenSecret};
    }

    @Override
    String getName() {
        return this.name == null ? "?user" : this.name;
    }

    private void init() {
        this.consumer = new SimpleOAuthConsumer(this.consumerKey, this.consumerSecret);
        if (this.accessToken != null) {
            this.consumer.setTokenWithSecret(this.accessToken, this.accessTokenSecret);
        }
        this.provider = new DefaultOAuthProvider("https://api.twitter.com/oauth/request_token", "https://api.twitter.com/oauth/access_token", "https://api.twitter.com/oauth/authorize");
    }

    @Override
    public HttpURLConnection post2_connect(String string, Map<String, String> map) throws IOException, OAuthException {
        String string2 = this.post2_getPayload(map);
        return this.post2_connect(string, string2, "application/x-www-form-urlencoded");
    }

    @Override
    public HttpURLConnection post2_connect(String string, JSONObject jSONObject) throws IOException, OAuthException {
        String string2 = jSONObject.toString();
        return this.post2_connect(string, string2, "application/json");
    }

    private HttpURLConnection post2_connect(String string, final String string2, String string3) throws IOException, OAuthException {
        String string4 = this.checkRateLimit(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Content-Type", string3);
        httpURLConnection.setReadTimeout(this.timeout);
        httpURLConnection.setConnectTimeout(this.timeout);
        HttpURLConnectionRequestAdapter httpURLConnectionRequestAdapter = new HttpURLConnectionRequestAdapter(httpURLConnection){

            public InputStream getMessagePayload() throws IOException {
                return new StringBufferInputStream(string2);
            }
        };
        this.consumer.sign((HttpRequest)httpURLConnectionRequestAdapter);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(string2.getBytes());
        InternalUtils.close(outputStream);
        this.processError(httpURLConnection, string4);
        this.processHeaders(httpURLConnection, string4);
        return httpURLConnection;
    }

    @Override
    protected void setAuthentication(URLConnection uRLConnection) {
        try {
            this.consumer.sign((Object)uRLConnection);
        }
        catch (OAuthException oAuthException) {
            throw new TwitterException((Exception)((Object)oAuthException));
        }
    }

    public void setAuthorizationCode(String string) throws TwitterException {
        this.setAuthorizationCode(string, null, null);
    }

    public void setAuthorizationCode(String string, String string2, String string3) throws TwitterException {
        if (this.accessToken != null) {
            this.accessToken = null;
            this.init();
        }
        try {
            if (string2 != null) {
                this.consumer.setTokenWithSecret(string2, string3);
            }
            this.provider.retrieveAccessToken(this.consumer, string, new String[0]);
            this.accessToken = this.consumer.getToken();
            this.accessTokenSecret = this.consumer.getTokenSecret();
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("401")) {
                throw new TwitterException.E401(exception.getMessage());
            }
            throw new TwitterException(exception);
        }
    }

    public void setFoursquareProvider() {
        this.setProvider((AbstractOAuthProvider)OAuthSignpostClient.FOURSQUARE_PROVIDER());
    }

    public void setLinkedInProvider() {
        this.setProvider((AbstractOAuthProvider)OAuthSignpostClient.LINKEDIN_PROVIDER());
    }

    public void setFlickrProvider() {
        this.setProvider((AbstractOAuthProvider)OAuthSignpostClient.FLICKR_PROVIDER());
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProvider(AbstractOAuthProvider abstractOAuthProvider) {
        this.provider = abstractOAuthProvider;
    }

    public HttpParameters getProviderResponseParams() {
        return this.provider.getResponseParameters();
    }
}

