/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.jgeoplanet.GeoCodeQuery;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.jgeoplanet.Location;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import winterwell.jtwitter.RateLimit;
import winterwell.jtwitter.Regex;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.User;

public class InternalUtils {
    public static final Pattern TAG_REGEX = Pattern.compile("<!?/?[\\[\\-a-zA-Z][^>]*>", 32);
    static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    static final DateFormat dfMarko = new SimpleDateFormat("EEE MMM dd HH:mm:ss ZZZZZ yyyy");
    static final DateFormat almost8601 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZZZ");
    public static final Pattern latLongLocn = Pattern.compile("(\\S+:)?\\s*(-?[\\d\\.]+)\\s*,\\s*(-?[\\d\\.]+)");
    static final Comparator<Status> NEWEST_FIRST = new Comparator<Status>(){

        @Override
        public int compare(Status status, Status status2) {
            return -status.id.compareTo(status2.id);
        }
    };
    public static final Pattern REGEX_JUST_DIGITS = Pattern.compile("\\d+");
    public static final Pattern DM = Pattern.compile("^dm? (\\w+)\\b", 2);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Pattern pComment = Pattern.compile("<!-*.*?-+>", 32);
    public static final Pattern pScriptOrStyle = Pattern.compile("<(script|style)[^<>]*>.+?</(script|style)>", 34);
    public static final Pattern pDocType = Pattern.compile("<!DOCTYPE.*?>", 34);
    public static final long HOUR = 3600000L;
    private static Method logFn;
    private static Method toCanonicalFn;
    private static boolean init;

    @Deprecated
    public static void setTrackAPIUsage(boolean bl) {
        RateLimit.setTrackAPIUsage(bl);
    }

    @Deprecated
    public static ConcurrentHashMap<String, Long> getAPIUsageStats() {
        return RateLimit.getAPIUsageStats();
    }

    public static Map<IPlace, Double> filterByReq(GeoCodeQuery geoCodeQuery, Map<IPlace, Double> map) {
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        if (!geoCodeQuery.reqGeometry && !geoCodeQuery.reqLocn) {
            return map;
        }
        HashMap<IPlace, Double> hashMap = new HashMap<IPlace, Double>(map.size());
        for (IPlace iPlace : map.keySet()) {
            if (geoCodeQuery.reqGeometry && iPlace.getBoundingBox() == null || geoCodeQuery.reqLocn && iPlace.getCentroid() == null) continue;
            hashMap.put(iPlace, map.get(iPlace));
        }
        return hashMap;
    }

    public static Map<IPlace, Double> prefer(GeoCodeQuery geoCodeQuery, List<? extends IPlace> list, String string, double d) {
        assert (list.size() != 0);
        assert (d >= 0.0 && d <= 1.0);
        ArrayList<IPlace> arrayList = new ArrayList<IPlace>();
        for (IPlace object2 : list) {
            if (!string.equals(object2.getType())) continue;
            arrayList.add(object2);
        }
        HashMap hashMap = new HashMap();
        List<Object> list2 = arrayList.size() != 0 ? arrayList : list;
        double d2 = d / (double)list.size();
        for (Object object : list2) {
            hashMap.put(object, d2);
        }
        Map<IPlace, Double> map = InternalUtils.filterByReq(geoCodeQuery, hashMap);
        return map;
    }

    public static String stripUrls(String string) {
        return Regex.VALID_URL.matcher(string).replaceAll("");
    }

    public static Map asMap(Object ... objectArray) {
        assert (objectArray.length % 2 == 0);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(objectArray.length / 2);
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i + 1];
            if (object == null) continue;
            hashMap.put(objectArray[i], object);
        }
        return hashMap;
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        if (closeable instanceof Flushable) {
            try {
                ((Flushable)((Object)closeable)).flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String encode(Object object) {
        String string;
        try {
            string = URLEncoder.encode(String.valueOf(object), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = URLEncoder.encode(String.valueOf(object));
        }
        string = string.replace("*", "%2A");
        return string.replace("+", "%20");
    }

    public static Date getDate(int n, String string, int n2) {
        try {
            Field field = GregorianCalendar.class.getField(string.toUpperCase());
            int n3 = field.getInt(null);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n3, n2);
            return gregorianCalendar.getTime();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    static Boolean getOptBoolean(JSONObject jSONObject, String string) throws JSONException {
        Object object = jSONObject.opt(string);
        if (object == null || object.equals(JSONObject.NULL)) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.equalsIgnoreCase("true")) {
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                return false;
            }
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (n == 1) {
                return true;
            }
            if (n == 0 || n == -1) {
                return false;
            }
        }
        System.err.println("JSON parse fail: " + object + " (" + string + ") is not boolean");
        return null;
    }

    static String join(List list, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = Math.min(n2, list.size());
        for (int i = n; i < n3; ++i) {
            stringBuilder.append(list.get(i));
            stringBuilder.append(",");
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(",");
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    protected static String jsonGet(String string, JSONObject jSONObject) {
        assert (string != null) : jSONObject;
        assert (jSONObject != null);
        Object object = jSONObject.opt(string);
        if (object == null) {
            return null;
        }
        if (JSONObject.NULL.equals(object)) {
            return null;
        }
        String string2 = object.toString();
        return string2;
    }

    static Date parseDate(String string) {
        if (REGEX_JUST_DIGITS.matcher(string).matches()) {
            long l = Long.valueOf(string);
            long l2 = l * 1000L;
            if (l2 > 7709085069990L) {
                return new Date(l);
            }
            return new Date(l2);
        }
        try {
            Date date = new Date(string);
            return date;
        }
        catch (Exception exception) {
            try {
                Date date = almost8601.parse(string);
                return date;
            }
            catch (ParseException parseException) {
                try {
                    Date date = dfMarko.parse(string);
                    return date;
                }
                catch (ParseException parseException2) {
                    throw new TwitterException.Parsing(string, parseException2);
                }
            }
        }
    }

    protected static String read(InputStream inputStream) {
        try {
            int n;
            Reader reader = new InputStreamReader(inputStream, UTF_8);
            reader = new BufferedReader(reader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = reader.read()) != -1) {
                stringBuilder.append((char)n);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    static String unencode(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("&quot;", "\"");
        string = string.replace("&apos;", "'");
        string = string.replace("&nbsp;", " ");
        string = string.replace("&amp;", "&");
        string = string.replace("&gt;", ">");
        if ((string = string.replace("&lt;", "<")).indexOf(0) != -1) {
            string = string.replace('\u0000', ' ').trim();
        }
        return string;
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return "";
        }
        String string2 = String.valueOf(string);
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = URLEncoder.encode(string2);
        }
        string2 = string2.replace("+", "%20");
        return string2;
    }

    static URI URI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    static User user(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            User user = new User(jSONObject, null);
            return user;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static String stripTags(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(60) == -1) {
            return string;
        }
        Matcher matcher = pScriptOrStyle.matcher(string);
        string = matcher.replaceAll("");
        Matcher matcher2 = pComment.matcher(string);
        String string2 = matcher2.replaceAll("");
        Matcher matcher3 = TAG_REGEX.matcher(string2);
        String string3 = matcher3.replaceAll("");
        Matcher matcher4 = pDocType.matcher(string3);
        String string4 = matcher4.replaceAll("");
        return string4;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    static boolean authoriseIn11(Twitter twitter) {
        return twitter.getHttpClient().canAuthenticate() || twitter.TWITTER_URL.endsWith("1.1");
    }

    public static BigInteger getMinId(BigInteger bigInteger, List<? extends Twitter.ITweet> list) {
        BigInteger bigInteger2 = bigInteger;
        for (Twitter.ITweet iTweet : list) {
            if (bigInteger2 != null && bigInteger2.compareTo(iTweet.getId()) <= 0) continue;
            bigInteger2 = iTweet.getId();
        }
        if (bigInteger2 != null) {
            bigInteger2 = bigInteger2.subtract(BigInteger.ONE);
        }
        return bigInteger2;
    }

    public static Date getMaxDate(List<? extends Twitter.ITweet> list) {
        Date date = null;
        for (Twitter.ITweet iTweet : list) {
            if (iTweet == null || iTweet.getCreatedAt() == null || date != null && !date.before(iTweet.getCreatedAt())) continue;
            date = iTweet.getCreatedAt();
        }
        return date;
    }

    public static <X> X getBest(Map<X, Double> map) {
        double d = Double.NEGATIVE_INFINITY;
        X x = null;
        for (Map.Entry<X, Double> entry : map.entrySet()) {
            if (!(entry.getValue() > d)) continue;
            x = entry.getKey();
        }
        return x;
    }

    public static Boolean geoMatch(GeoCodeQuery geoCodeQuery, IPlace iPlace) {
        Object object;
        if (iPlace == null) {
            return null;
        }
        boolean bl = false;
        if (geoCodeQuery.country != null) {
            object = iPlace.getCountryCode();
            if (object == null) {
                bl = true;
            } else if (!geoCodeQuery.country.equals(object)) {
                return false;
            }
        }
        if (geoCodeQuery.city != null) {
            // empty if block
        }
        if (geoCodeQuery.bbox != null) {
            object = iPlace.getCentroid();
            if (object != null && !geoCodeQuery.bbox.contains((Location)object)) {
                return false;
            }
            if (object != null && geoCodeQuery.bbox.contains((Location)object)) {
                return true;
            }
            bl = true;
        }
        if ((object = InternalUtils.filterByReq(geoCodeQuery, Collections.singletonMap(iPlace, 1.0))).isEmpty()) {
            return false;
        }
        if (bl && geoCodeQuery.desc != null && !geoCodeQuery.desc.isEmpty() && iPlace.getName() != null && !iPlace.getName().isEmpty()) {
            String string = InternalUtils.toCanonical(geoCodeQuery.desc);
            String string2 = InternalUtils.toCanonical(iPlace.getName());
            Pattern pattern = Pattern.compile("\\b" + Pattern.quote(string) + "\\b");
            if (pattern.matcher(string2).find()) {
                return true;
            }
        }
        return bl ? null : Boolean.valueOf(true);
    }

    public static String toCanonical(String string) {
        InternalUtils.init();
        if (toCanonicalFn != null) {
            try {
                return (String)toCanonicalFn.invoke(null, string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') continue;
            if (Character.isLetterOrDigit(c)) {
                bl = false;
                c = Character.toLowerCase(c);
                stringBuilder.append(c);
                continue;
            }
            if (bl || stringBuilder.length() == 0) continue;
            stringBuilder.append(' ');
            bl = true;
        }
        if (bl) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        string = stringBuilder.toString();
        return string;
    }

    public static void log(String string, Object object) {
        InternalUtils.init();
        if (logFn != null) {
            try {
                logFn.invoke(null, string, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void init() {
        Class<?> clazz;
        if (init) {
            return;
        }
        init = true;
        try {
            clazz = Class.forName("com.winterwell.utils.log.Log");
            logFn = clazz.getMethod("w", String.class, Object.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            clazz = Class.forName("com.winterwell.utils.StrUtils");
            toCanonicalFn = clazz.getMethod("toCanonical", String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static BigInteger toBigInteger(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            return bigDecimal.toBigInteger();
        }
        long l = number.longValue();
        return BigInteger.valueOf(l);
    }

    public static String str(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i]);
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String str(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Throwable) {
            return InternalUtils.toString((Throwable)object, true);
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                stringBuilder.append(object2);
                stringBuilder.append(", ");
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            return stringBuilder.toString();
        }
        return object.toString();
    }

    public static String toString(Throwable throwable, boolean bl) {
        if (throwable.getClass().toString().contains("WrappedException")) {
            throwable = throwable.getCause();
        }
        if (!bl) {
            return throwable.getMessage() == null ? throwable.getClass().getSimpleName() : throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(throwable.getClass() + ": " + throwable.getMessage());
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        InternalUtils.close(printWriter);
        return stringWriter.toString();
    }

    public static Object or(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object == null || object.toString().isEmpty()) continue;
            return object;
        }
        return null;
    }

    public static BigInteger addTimeToStatusId(BigInteger bigInteger, long l) {
        if (bigInteger == null) {
            return null;
        }
        long l2 = bigInteger.longValue();
        long l3 = l2 >> 22;
        long l4 = l2 - (l3 << 22);
        return BigInteger.valueOf(((l3 += l) << 22) + l4);
    }

    public static String trimPunctuation(String string) {
        Pattern pattern = Pattern.compile("^\\p{Punct}*(.*?)\\p{Punct}*$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string.trim();
        }
        String string2 = matcher.group(1).trim();
        return string2;
    }

    public static String removePunctuation(String string) {
        Pattern pattern = Pattern.compile("\\p{Punct}+");
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.replaceAll(" ").replaceAll(" +", " ");
        return string2;
    }

    public static void pop(StringBuilder stringBuilder, int n) {
        stringBuilder.delete(stringBuilder.length() - n, stringBuilder.length());
    }
}

