/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.BoundingBox;
import com.winterwell.jgeoplanet.GeoCodeQuery;
import com.winterwell.jgeoplanet.GeoPlanetException;
import com.winterwell.jgeoplanet.IGeoCode;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.jgeoplanet.ISO3166;
import com.winterwell.jgeoplanet.Location;
import com.winterwell.jgeoplanet.PlaceNotFoundException;
import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.util.Collections;
import java.util.Map;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.URLConnectionHttpClient;

public class GoogleGeocoding
implements IGeoCode {
    long RATE_LIMIT_HIT;

    @Override
    public Boolean matches(GeoCodeQuery geoCodeQuery, IPlace iPlace) {
        return InternalUtils.geoMatch(geoCodeQuery, iPlace);
    }

    @Override
    public GPlace getPlace(String string) throws GeoPlanetException {
        if (string == null) {
            throw new NullPointerException();
        }
        if ((string = string.replaceAll("\\s+", " ").trim()).isEmpty()) {
            throw new IllegalArgumentException();
        }
        Map<IPlace, Double> map = this.getPlace(new GeoCodeQuery(string));
        IPlace iPlace = InternalUtils.getBest(map);
        return (GPlace)iPlace;
    }

    @Override
    public Map<IPlace, Double> getPlace(GeoCodeQuery geoCodeQuery) {
        if (System.currentTimeMillis() - this.RATE_LIMIT_HIT < 180000L) {
            throw new TwitterException.PreEmptiveRateLimit("OVER_QUERY_LIMIT request not sent *TO GOOGLE* (" + geoCodeQuery + ")");
        }
        String string = null;
        try {
            URLConnectionHttpClient uRLConnectionHttpClient = new URLConnectionHttpClient();
            string = uRLConnectionHttpClient.getPage("http://maps.googleapis.com/maps/api/geocode/json?sensor=false&address=" + InternalUtils.urlEncode(geoCodeQuery.desc), null, false);
            if (string.contains("OVER_QUERY_LIMIT")) {
                this.RATE_LIMIT_HIT = System.currentTimeMillis();
                throw new TwitterException.RateLimit("OVER_QUERY_LIMIT (" + geoCodeQuery.desc + ")");
            }
            JSONObject jSONObject = new JSONObject(string);
            JSONArray jSONArray = jSONObject.getJSONArray("results");
            if (jSONArray.length() == 0) {
                throw new PlaceNotFoundException(geoCodeQuery.desc);
            }
            Map<IPlace, Double> map = Collections.singletonMap(new GPlace(jSONArray.getJSONObject(0)), 0.85);
            return map;
        }
        catch (GeoPlanetException geoPlanetException) {
            throw geoPlanetException;
        }
        catch (Exception exception) {
            throw new GeoPlanetException(exception);
        }
    }

    public static class GPlace
    implements IPlace {
        private String name;
        private String country;
        private Location centroid;
        private BoundingBox bbox;
        private String[] types;

        @Override
        public String getCountryCode() {
            return new ISO3166().getCountryCode(this.country);
        }

        @Override
        public Location getCentroid() {
            return this.centroid;
        }

        @Override
        public Class<? extends IGeoCode> getGeoCoder() {
            return GoogleGeocoding.class;
        }

        @Override
        public IPlace getParent() {
            return null;
        }

        public GPlace(JSONObject jSONObject) throws JSONException {
            JSONArray jSONArray;
            Object object;
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            JSONArray jSONArray2 = jSONObject.getJSONArray("address_components");
            boolean bl = false;
            if (jSONArray2.length() == 0) {
                this.name = "";
                this.country = "";
            } else {
                jSONObject3 = jSONArray2.getJSONObject(0);
                this.name = jSONObject3.getString("long_name");
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    jSONObject2 = jSONArray2.getJSONObject(i);
                    object = jSONObject2.optJSONArray("types");
                    if (object == null || ((JSONArray)object).length() == 0 || !"country".equals(((JSONArray)object).get(0))) continue;
                    this.country = jSONObject2.getString("long_name");
                    break;
                }
            }
            jSONObject3 = jSONObject.getJSONObject("geometry");
            if (jSONObject3 != null) {
                JSONObject jSONObject4 = jSONObject3.getJSONObject("location");
                if (jSONObject4 != null) {
                    this.centroid = new Location(jSONObject4.getDouble("lat"), jSONObject4.getDouble("lng"));
                }
                if ((jSONObject2 = jSONObject3.optJSONObject("bounds")) == null) {
                    jSONObject2 = jSONObject3.optJSONObject("viewport");
                }
                if (jSONObject2 != null) {
                    object = jSONObject2.getJSONObject("northeast");
                    JSONObject jSONObject5 = jSONObject2.getJSONObject("southwest");
                    Location location = new Location(((JSONObject)object).getDouble("lat"), ((JSONObject)object).getDouble("lng"));
                    Location location2 = new Location(jSONObject5.getDouble("lat"), jSONObject5.getDouble("lng"));
                    this.bbox = new BoundingBox(location, location2);
                    if (this.centroid == null) {
                        this.centroid = this.bbox.getCenter();
                    }
                }
            }
            if ((jSONArray = jSONObject.optJSONArray("types")) == null) {
                this.types = new String[0];
            } else {
                int n = jSONArray.length();
                this.types = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.types[i] = jSONArray.getString(i);
                }
            }
        }

        @Override
        public String getUID() {
            return this.name + this.getType() + this.centroid + "@googlemaps";
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getCountry() {
            return this.country;
        }

        @Override
        public BoundingBox getBoundingBox() {
            return this.bbox;
        }

        @Override
        public String getType() {
            if (this.types.length == 0) {
                return null;
            }
            return this.types[0];
        }
    }
}

