/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.Dx;
import com.winterwell.jgeoplanet.Location;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;

public class BoundingBox {
    final Location northEast;
    final Location southWest;

    public BoundingBox(Location location, Location location2) {
        if (location.latitude < location2.latitude) {
            throw new IllegalArgumentException("North east corner is south of south west corner");
        }
        this.northEast = location;
        this.southWest = location2;
    }

    public Location getCenter() {
        Location location = this.northEast;
        Location location2 = this.southWest;
        double d = (location.latitude + location2.latitude) / 2.0;
        if (Math.abs(location.latitude - location2.latitude) > 90.0) {
            d = d <= 0.0 ? (d += 90.0) : (d -= 90.0);
        }
        double d2 = (location.longitude + location2.longitude) / 2.0;
        if (Math.abs(location.longitude - location2.longitude) > 180.0) {
            d2 = d2 <= 0.0 ? (d2 += 180.0) : (d2 -= 180.0);
        }
        Location location3 = new Location(d, d2);
        return location3;
    }

    BoundingBox(JSONObject jSONObject) throws JSONException {
        this(BoundingBox.getLocation(jSONObject.getJSONObject("northEast")), BoundingBox.getLocation(jSONObject.getJSONObject("southWest")));
    }

    public BoundingBox(Location location, Dx dx) {
        double d = dx.getMetres();
        this.northEast = location.move(d, d);
        this.southWest = location.move(-d, -d);
    }

    public Location getNorthEast() {
        return this.northEast;
    }

    public Location getSouthWest() {
        return this.southWest;
    }

    public Location getNorthWest() {
        return new Location(this.northEast.latitude, this.southWest.longitude);
    }

    public Location getSouthEast() {
        return new Location(this.southWest.latitude, this.northEast.longitude);
    }

    public boolean contains(Location location) {
        if (location.latitude > this.northEast.latitude) {
            return false;
        }
        if (location.latitude < this.southWest.latitude) {
            return false;
        }
        if (this.northEast.longitude < 0.0 && this.southWest.longitude >= 0.0 && this.southWest.longitude > this.northEast.longitude) {
            if (location.longitude < 0.0 && location.longitude > this.northEast.longitude) {
                return false;
            }
            if (location.longitude >= 0.0 && location.longitude < this.southWest.longitude) {
                return false;
            }
        } else {
            if (location.longitude > this.northEast.longitude) {
                return false;
            }
            if (location.longitude < this.southWest.longitude) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(BoundingBox boundingBox) {
        return this.contains(boundingBox.southWest) && this.contains(boundingBox.northEast);
    }

    public boolean intersects(BoundingBox boundingBox) {
        return this.contains(boundingBox.northEast) || this.contains(boundingBox.southWest) || this.contains(boundingBox.getNorthWest()) || this.contains(boundingBox.getSouthEast());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.northEast == null ? 0 : this.northEast.hashCode());
        n = 31 * n + (this.southWest == null ? 0 : this.southWest.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)object;
        if (this.northEast == null ? boundingBox.northEast != null : !this.northEast.equals(boundingBox.northEast)) {
            return false;
        }
        return !(this.southWest == null ? boundingBox.southWest != null : !this.southWest.equals(boundingBox.southWest));
    }

    public String toString() {
        return "BoundingBox [northEast=" + this.northEast + ", southWest=" + this.southWest + "]";
    }

    static Location getLocation(JSONObject jSONObject) throws JSONException {
        return new Location(jSONObject.getDouble("latitude"), jSONObject.getDouble("longitude"));
    }

    public boolean isPoint() {
        return this.northEast.equals(this.southWest);
    }
}

