/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter.ecosystem;

import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.text.ParseException;
import java.util.Map;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.URLConnectionHttpClient;
import winterwell.jtwitter.ecosystem.TwitterCounterStats;

public class TwitterCounter {
    final String apiKey;
    Twitter.IHttpClient client = new URLConnectionHttpClient();

    public Twitter.IHttpClient getClient() {
        return this.client;
    }

    public TwitterCounter(String string) {
        this.apiKey = string;
    }

    public TwitterCounterStats getStats(Number number) {
        Map map = InternalUtils.asMap("twitter_id", number, "apikey", this.apiKey);
        String string = this.client.getPage("http://api.twittercounter.com/", map, false);
        try {
            JSONObject jSONObject = new JSONObject(string);
            return new TwitterCounterStats(jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
        catch (ParseException parseException) {
            throw new TwitterException.Parsing(string, parseException);
        }
    }
}

