/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter.ecosystem;

import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.util.Map;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.URLConnectionHttpClient;

public class Topsy {
    private Twitter.IHttpClient client = new URLConnectionHttpClient();
    private String apikey;

    public Topsy() {
    }

    public Topsy(String string) {
        this.apikey = string;
    }

    public UrlInfo getUrlInfo(String string) {
        Map map = InternalUtils.asMap("url", string);
        if (this.apikey != null) {
            map.put("apikey", this.apikey);
        }
        String string2 = this.client.getPage("http://otter.topsy.com/urlinfo.json", map, false);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            JSONObject jSONObject2 = jSONObject.getJSONObject("response");
            return new UrlInfo(jSONObject2);
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public static final class UrlInfo {
        public final String title;
        public final int linkCount;
        public final String desc;
        public final String url;

        public UrlInfo(JSONObject jSONObject) throws JSONException {
            this.url = jSONObject.getString("url");
            this.title = jSONObject.getString("title");
            this.linkCount = jSONObject.getInt("trackback_total");
            this.desc = jSONObject.getString("description");
        }

        public String toString() {
            return this.url + " " + this.linkCount + " " + this.title;
        }
    }
}

