/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.ListWithCursor;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.User;

public class Twitter_Users {
    private final Twitter.IHttpClient http;
    private final Twitter jtwit;
    String cursor = "-1";

    Twitter_Users(Twitter twitter) {
        this.jtwit = twitter;
        this.http = twitter.getHttpClient();
    }

    public User block(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("screen_name", string);
        String string2 = this.http.post(this.jtwit.TWITTER_URL + "/blocks/create.json", hashMap, true);
        return InternalUtils.user(string2);
    }

    List<User> bulkShow2(String string, Class clazz, Collection collection) {
        boolean bl = InternalUtils.authoriseIn11(this.jtwit);
        int n = 100;
        ArrayList<User> arrayList = new ArrayList<User>(collection.size());
        List list = collection instanceof List ? (List)collection : new ArrayList(collection);
        for (int i = 0; i < list.size(); i += n) {
            int n2 = i + n;
            String string2 = InternalUtils.join(list, i, n2);
            String string3 = clazz == String.class ? "screen_name" : "user_id";
            Map map = InternalUtils.asMap(string3, string2);
            try {
                String string4 = this.http.getPage(this.jtwit.TWITTER_URL + string, map, bl);
                List<User> list2 = User.getUsers(string4);
                arrayList.addAll(list2);
                continue;
            }
            catch (TwitterException.E404 e404) {
                continue;
            }
            catch (TwitterException twitterException) {
                if (arrayList.size() == 0) {
                    throw twitterException;
                }
                twitterException.printStackTrace();
                break;
            }
        }
        return arrayList;
    }

    public User follow(String string) throws TwitterException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals(this.jtwit.getScreenName())) {
            throw new IllegalArgumentException("follow yourself makes no sense");
        }
        String string2 = null;
        try {
            Map map = InternalUtils.asMap("screen_name", string);
            string2 = this.http.post(this.jtwit.TWITTER_URL + "/friendships/create.json", map, true);
            return new User(new JSONObject(string2), null);
        }
        catch (TwitterException.SuspendedUser suspendedUser) {
            throw suspendedUser;
        }
        catch (TwitterException.UserNotFound userNotFound) {
            throw userNotFound;
        }
        catch (TwitterException.AgeScreen ageScreen) {
            throw ageScreen;
        }
        catch (TwitterException.Repetition repetition) {
            return null;
        }
        catch (TwitterException.E403 e403) {
            try {
                if (this.isFollowing(string)) {
                    return null;
                }
            }
            catch (TwitterException twitterException) {
                // empty catch block
            }
            throw e403;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public User follow(User user) {
        return this.follow(user.screenName);
    }

    public List<Number> getBlockedIds() {
        String string = this.http.getPage(this.jtwit.TWITTER_URL + "/blocks/ids.json", null, true);
        try {
            JSONArray jSONArray = string.startsWith("[") ? new JSONArray(string) : new JSONObject(string).getJSONArray("ids");
            ArrayList<Number> arrayList = new ArrayList<Number>(jSONArray.length());
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                arrayList.add(jSONArray.getLong(i));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public ListWithCursor<Number> getFollowerIDs() throws TwitterException {
        return this.getUserIDs(this.jtwit.TWITTER_URL + "/followers/ids.json", null, null);
    }

    public ListWithCursor<Number> getFollowerIDs(String string) throws TwitterException {
        return this.getUserIDs(this.jtwit.TWITTER_URL + "/followers/ids.json", string, null);
    }

    public ListWithCursor<Number> getFollowerIDs(long l) throws TwitterException {
        return this.getUserIDs(this.jtwit.TWITTER_URL + "/followers/ids.json", null, l);
    }

    @Deprecated
    public List<User> getFollowers() throws TwitterException {
        ListWithCursor<Number> listWithCursor = this.getFollowerIDs();
        return this.getTweeps2(listWithCursor);
    }

    public List<User> getFollowers(String string) throws TwitterException {
        ListWithCursor<Number> listWithCursor = this.getFollowerIDs(string);
        return this.getTweeps2(listWithCursor);
    }

    public ListWithCursor<Number> getFriendIDs() throws TwitterException {
        return this.getUserIDs(this.jtwit.TWITTER_URL + "/friends/ids.json", null, null);
    }

    public ListWithCursor<Number> getFriendIDs(String string) throws TwitterException {
        return this.getUserIDs(this.jtwit.TWITTER_URL + "/friends/ids.json", string, null);
    }

    public ListWithCursor<Number> getFriendIDs(long l) throws TwitterException {
        return this.getUserIDs(this.jtwit.TWITTER_URL + "/friends/ids.json", null, l);
    }

    @Deprecated
    public List<User> getFriends() throws TwitterException {
        ListWithCursor<Number> listWithCursor = this.getFriendIDs();
        return this.getTweeps2(listWithCursor);
    }

    public List<User> getFriends(String string) throws TwitterException {
        ListWithCursor<Number> listWithCursor = this.getFriendIDs(string);
        return this.getTweeps2(listWithCursor);
    }

    private List<User> getTweeps2(List<Number> list) {
        if (list.size() > 100) {
            list = list.subList(0, 100);
        }
        List<User> list2 = this.showById(list);
        return list2;
    }

    public List<User> getRelationshipInfo(List<String> list) {
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        List<User> list2 = this.bulkShow2("/friendships/lookup.json", String.class, list);
        return list2;
    }

    public List<User> getRelationshipInfoById(List<? extends Number> list) {
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        List<User> list2 = this.bulkShow2("/friendships/lookup.json", Number.class, list);
        return list2;
    }

    public User getUser(long l) {
        return this.show(l);
    }

    public User getUser(String string) {
        return this.show(string);
    }

    public Twitter_Users setCursor(String string) {
        this.cursor = string == null ? "-1" : string;
        return this;
    }

    private ListWithCursor<Number> getUserIDs(String string, String string2, Long l) {
        String string3 = this.cursor;
        ListWithCursor<Number> listWithCursor = new ListWithCursor<Number>();
        if (string2 != null && l != null) {
            throw new IllegalArgumentException("cannot use both screen_name and user_id when fetching user_ids");
        }
        Map map = InternalUtils.asMap("screen_name", string2, "user_id", l);
        while (!this.jtwit.enoughResults(listWithCursor)) {
            map.put("cursor", string3);
            if (this.jtwit.getMaxResults() > 0 && this.jtwit.getMaxResults() < 5000) {
                map.put("count", String.valueOf(this.jtwit.getMaxResults()));
            }
            String string4 = this.http.getPage(string, map, this.http.canAuthenticate());
            try {
                JSONArray jSONArray;
                if (string4.charAt(0) == '[') {
                    jSONArray = new JSONArray(string4);
                    string3 = "lost";
                } else {
                    JSONObject jSONObject = new JSONObject(string4);
                    jSONArray = (JSONArray)jSONObject.get("ids");
                    string3 = jSONObject.getString("next_cursor");
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    listWithCursor.add(jSONArray.getLong(i));
                }
                if ("0".equals(string3)) {
                    string3 = "end";
                }
                listWithCursor.setCursor(string3);
                if (listWithCursor.hasCursor() && jSONArray.length() >= 1000) continue;
                break;
            }
            catch (JSONException jSONException) {
                throw new TwitterException.Parsing(string4, jSONException);
            }
            catch (TwitterException.RateLimit rateLimit) {
                if (listWithCursor.isEmpty()) {
                    throw rateLimit;
                }
                InternalUtils.log("getUserIDs", rateLimit);
            }
        }
        return listWithCursor;
    }

    public boolean isBlocked(Long l) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("user_id", Long.toString(l));
            String string = this.http.getPage(this.jtwit.TWITTER_URL + "/blocks/exists.json", hashMap, true);
            return true;
        }
        catch (TwitterException.E404 e404) {
            return false;
        }
    }

    public boolean isBlocked(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("screen_name", string);
            String string2 = this.http.getPage(this.jtwit.TWITTER_URL + "/blocks/exists.json", hashMap, true);
            return true;
        }
        catch (TwitterException.E404 e404) {
            return false;
        }
    }

    public boolean isFollower(String string) {
        return this.isFollower(string, this.jtwit.getScreenName());
    }

    private boolean isFollower(Map map) {
        String string = (String)map.get("source_screen_name");
        Number number = (Number)map.get("source_id");
        String string2 = (String)map.get("target_screen_name");
        Number number2 = (Number)map.get("target_id");
        assert (string != null || number != null) : "No follower name / ID";
        assert (string2 != null || number2 != null) : "No followed name / ID";
        try {
            String string3 = this.http.getPage(this.jtwit.TWITTER_URL + "/friendships/show.json", map, this.http.canAuthenticate());
            JSONObject jSONObject = new JSONObject(string3);
            JSONObject jSONObject2 = jSONObject.getJSONObject("relationship").getJSONObject("target");
            boolean bl = jSONObject2.getBoolean("followed_by");
            return bl;
        }
        catch (TwitterException.E403 e403) {
            if (e403 instanceof TwitterException.SuspendedUser) {
                throw e403;
            }
            Boolean bl = this.jtwit.self != null ? this.jtwit.self.getId().equals(number) || this.jtwit.getScreenName().equals(string) : false;
            Boolean bl2 = this.jtwit.self != null ? this.jtwit.self.getId().equals(number2) || this.jtwit.getScreenName().equals(string2) : false;
            try {
                if (!bl.booleanValue()) {
                    if (number != null) {
                        this.show(number);
                    }
                    if (string != null) {
                        this.show(string);
                    }
                }
                if (!bl2.booleanValue()) {
                    if (number2 != null) {
                        this.show(number2);
                    }
                    if (string2 != null) {
                        this.show(string2);
                    }
                }
            }
            catch (TwitterException.RateLimit rateLimit) {
                // empty catch block
            }
            throw e403;
        }
        catch (TwitterException twitterException) {
            if (twitterException.getMessage() != null && twitterException.getMessage().contains("Two user ids or screen_names must be supplied")) {
                throw new TwitterException("WTF? inputs: " + map + ", call-by=" + this.jtwit.getScreenName() + "; " + twitterException.getMessage());
            }
            throw twitterException;
        }
    }

    public boolean isFollower(String string, String string2) {
        return this.isFollower(InternalUtils.asMap("source_screen_name", string, "target_screen_name", string2));
    }

    public boolean isFollower(String string, Number number) {
        return this.isFollower(InternalUtils.asMap("source_screen_name", string, "target_id", number));
    }

    public boolean isFollower(Number number, String string) {
        return this.isFollower(InternalUtils.asMap("source_id", number, "target_screen_name", string));
    }

    public boolean isFollower(Number number, Number number2) {
        return this.isFollower(InternalUtils.asMap("source_id", number, "target_id", number2));
    }

    public boolean isFollowing(String string) {
        return this.isFollower(this.jtwit.getScreenName(), string);
    }

    public boolean isFollowing(User user) {
        return this.isFollowing(user.screenName);
    }

    public User leaveNotifications(String string) {
        return this.setNotifications(string, false, null);
    }

    public User setNotifications(String string, Boolean bl, Boolean bl2) {
        if (bl == null && bl2 == null) {
            return null;
        }
        Map map = InternalUtils.asMap("screen_name", string, "device", bl, "retweets", bl2);
        String string2 = this.http.post(this.jtwit.TWITTER_URL + "/friendships/update.json", map, true);
        try {
            JSONObject jSONObject = new JSONObject(string2).getJSONObject("relationship").getJSONObject("target");
            return new User(jSONObject, null);
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public User notify(String string) {
        Map map = InternalUtils.asMap("screen_name", string);
        String string2 = this.http.getPage(this.jtwit.TWITTER_URL + "/notifications/follow.json", map, true);
        try {
            return new User(new JSONObject(string2), null);
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public User reportSpammer(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("screen_name", string);
        String string2 = this.http.post(this.jtwit.TWITTER_URL + "/report_spam.json", hashMap, true);
        return InternalUtils.user(string2);
    }

    public List<User> searchUsers(String string) {
        return this.searchUsers(string, 0);
    }

    public List<User> searchUsers(String string, int n) {
        assert (string != null);
        Map map = InternalUtils.asMap("q", string);
        if (n > 1) {
            map.put("page", Integer.toString(n));
        }
        if (this.jtwit.count != null && this.jtwit.count < 20) {
            map.put("per_page", String.valueOf(this.jtwit.count));
        }
        String string2 = this.http.getPage(this.jtwit.TWITTER_URL + "/users/search.json", map, true);
        List<User> list = User.getUsers(string2);
        return list;
    }

    public List<User> show(Collection<String> collection) {
        if (collection.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return this.bulkShow2("/users/lookup.json", String.class, collection);
    }

    public User show(Number number) {
        Map map = InternalUtils.asMap("user_id", number.toString());
        String string = this.http.getPage(this.jtwit.TWITTER_URL + "/users/show.json", map, this.http.canAuthenticate());
        try {
            User user = new User(new JSONObject(string), null);
            return user;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public User show(String string) throws TwitterException, TwitterException.SuspendedUser {
        Map map = InternalUtils.asMap("screen_name", string);
        String string2 = "";
        try {
            string2 = this.http.getPage(this.jtwit.TWITTER_URL + "/users/show.json", map, this.http.canAuthenticate());
        }
        catch (Exception exception) {
            throw new TwitterException.E404("User " + string + " does not seem to exist, their user account may have been removed from the service");
        }
        if (string2.length() == 0) {
            throw new TwitterException.E404(string + " does not seem to exist");
        }
        try {
            User user = new User(new JSONObject(string2), null);
            return user;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public List<User> showById(Collection<? extends Number> collection) {
        if (collection.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return this.bulkShow2("/users/lookup.json", Number.class, collection);
    }

    public User stopFollowing(String string) {
        String string2;
        Object object;
        try {
            object = InternalUtils.asMap("screen_name", string);
            string2 = this.jtwit.http.post(this.jtwit.TWITTER_URL + "/friendships/destroy.json", (Map<String, String>)object, true);
        }
        catch (TwitterException twitterException) {
            if (twitterException.getMessage() != null && twitterException.getMessage().contains("not friends")) {
                return null;
            }
            throw twitterException;
        }
        try {
            object = new User(new JSONObject(string2), null);
            return object;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public User stopFollowing(User user) {
        return this.stopFollowing(user.screenName);
    }

    public User unblock(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("screen_name", string);
        String string2 = this.http.post(this.jtwit.TWITTER_URL + "/blocks/destroy.json", hashMap, true);
        return InternalUtils.user(string2);
    }

    public boolean userExists(String string) {
        try {
            this.show(string);
        }
        catch (TwitterException.SuspendedUser suspendedUser) {
            return false;
        }
        catch (TwitterException.E404 e404) {
            return false;
        }
        return true;
    }
}

