/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONException;
import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import winterwell.jtwitter.InternalUtils;

public class TwitterException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String additionalInfo = "";

    TwitterException(Exception exception) {
        super(exception);
        assert (!(exception instanceof TwitterException)) : exception;
    }

    public TwitterException(String string) {
        super(string);
    }

    TwitterException(String string, Exception exception) {
        super(string, exception);
        assert (!(exception instanceof TwitterException)) : exception;
    }

    public TwitterException(String string, String string2) {
        this(string);
        this.setAdditionalInfo(string2);
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String string) {
        this.additionalInfo = string;
    }

    public static class UpdateToOAuth
    extends E401 {
        private static final long serialVersionUID = 1L;

        public UpdateToOAuth() {
            super("You need to switch to OAuth. Twitter no longer support basic authentication.");
        }
    }

    public static class Unexplained
    extends TwitterException {
        private static final long serialVersionUID = 1L;

        public Unexplained(String string) {
            super(string);
        }
    }

    public static class TwitLongerException
    extends TwitterException {
        private static final long serialVersionUID = 1L;

        public TwitLongerException(String string, String string2) {
            super(string, string2);
        }
    }

    public static class AgeScreen
    extends E403 {
        private static final long serialVersionUID = 1L;

        AgeScreen(String string) {
            super(string);
        }
    }

    public static class TooSpammy
    extends E403 {
        private static final long serialVersionUID = 1L;

        TooSpammy(String string) {
            super(string);
        }
    }

    public static class TooRecent
    extends E403 {
        private static final long serialVersionUID = 1L;

        TooRecent(String string) {
            super(string);
        }
    }

    public static class TooManyLogins
    extends E40X {
        private static final long serialVersionUID = 1L;

        public TooManyLogins(String string) {
            super(string);
        }
    }

    public static class UploadTooBig
    extends E40X {
        private static final long serialVersionUID = 1L;

        public UploadTooBig(String string) {
            super(string);
        }
    }

    public static class Timeout
    extends E50X {
        private static final long serialVersionUID = 1L;

        public Timeout(String string) {
            super(string);
        }
    }

    public static class Blocked
    extends E403 {
        private static final long serialVersionUID = 1L;
        public final String targetUser;

        public Blocked(String string, String string2) {
            super(string);
            this.targetUser = string2;
        }
    }

    public static class SuspendedProfile
    extends E403 {
        private static final long serialVersionUID = 1L;

        public SuspendedProfile(String string) {
            super(string);
        }
    }

    public static class SuspendedUser
    extends E403 {
        private static final long serialVersionUID = 1L;
        public final boolean suspendedCaller;

        public SuspendedUser(String string) {
            super(string);
            this.suspendedCaller = string != null && string.contains("code 64:");
        }
    }

    public static class RepeatRetweet
    extends E403 {
        private static final long serialVersionUID = 1L;

        public RepeatRetweet(String string) {
            super("Already Retweeted! " + string);
        }
    }

    public static class Repetition
    extends E403 {
        private static final long serialVersionUID = 1L;

        public Repetition(String string) {
            super("Already tweeted! " + string);
        }
    }

    public static class PreEmptiveRateLimit
    extends RateLimit {
        private static final long serialVersionUID = 1L;

        public PreEmptiveRateLimit(String string) {
            super(string);
            InternalUtils.log("PreEmptiveRateLimit", "Usage stats: " + winterwell.jtwitter.RateLimit.getAPIUsageStats());
        }
    }

    public static class RateLimit
    extends TwitterException {
        private static final long serialVersionUID = 1L;

        public RateLimit(String string) {
            super(string);
        }
    }

    public static class Parsing
    extends TwitterException {
        private static final long serialVersionUID = 1L;

        private static String clip(String string, int n) {
            return string == null ? null : (string.length() <= n ? string : string.substring(0, n) + "...");
        }

        public Parsing(String string, JSONException jSONException) {
            super((string == null ? String.valueOf(jSONException) : Parsing.clip(string, 280)) + Parsing.causeLine(jSONException), jSONException);
        }

        private static String causeLine(JSONException jSONException) {
            StackTraceElement[] stackTraceElementArray;
            if (jSONException == null) {
                return "";
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray = jSONException.getStackTrace()) {
                if (stackTraceElement.getClassName().contains("JSON")) continue;
                return " caused by " + stackTraceElement;
            }
            return "";
        }

        public Parsing(String string, ParseException parseException) {
            super(string, parseException);
        }
    }

    public static class IO
    extends TwitterException {
        private static final long serialVersionUID = 1L;

        public IO(IOException iOException) {
            super(iOException);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }

    public static class FollowerLimit
    extends E403 {
        private static final long serialVersionUID = 1L;

        public FollowerLimit(String string) {
            super(0, string);
        }
    }

    public static class E50X
    extends TwitterException {
        private static final long serialVersionUID = 1L;

        public E50X(String string) {
            super(E50X.msg(string));
        }

        static String msg(String object) {
            if (object == null) {
                return null;
            }
            object = InternalUtils.TAG_REGEX.matcher((CharSequence)object).replaceAll("");
            if (((String)(object = ((String)object).replaceAll("\\s+", " "))).length() > 280) {
                object = ((String)object).substring(0, 280) + "...";
            }
            return object;
        }
    }

    public static class E416
    extends E40X {
        private static final long serialVersionUID = 1L;

        public E416(String string) {
            super(string);
        }
    }

    public static class E413
    extends E40X {
        private static final long serialVersionUID = 1L;

        public E413(String string) {
            super(string);
        }
    }

    public static class E40X
    extends TwitterException {
        private static final long serialVersionUID = 1L;

        public E40X(String string) {
            super(string);
        }
    }

    public static class E406
    extends E40X {
        private static final long serialVersionUID = 1L;

        public E406(String string) {
            super(string);
        }
    }

    public static class MissingUser
    extends E404 {
        private static final long serialVersionUID = 1L;

        public MissingUser(String string) {
            super(string);
        }
    }

    public static class E404
    extends E40X {
        private static final long serialVersionUID = 1L;

        public E404(String string) {
            super(string);
        }
    }

    public static class E403
    extends E40X {
        private static final long serialVersionUID = 1L;
        public final int code;
        static final Pattern CODE = Pattern.compile("code (\\d+):");

        public E403(String string) {
            super(string);
            if (string == null) {
                this.code = 0;
                return;
            }
            Matcher matcher = CODE.matcher(string);
            this.code = matcher.find() ? Integer.valueOf(matcher.group(1)) : 0;
        }

        public E403(int n, String string) {
            super(string);
            this.code = n;
        }
    }

    public static class E401
    extends E40X {
        private static final long serialVersionUID = 1L;

        public E401(String string) {
            super(string);
        }
    }

    public static class BadParameter
    extends E403 {
        private static final long serialVersionUID = 1L;

        public BadParameter(String string) {
            super(0, string);
        }
    }

    public static class UserNotFound
    extends E403 {
        private static final long serialVersionUID = 1L;

        public UserNotFound(String string) {
            super(108, string);
        }
    }

    public static class AccessLevel
    extends E401 {
        private static final long serialVersionUID = 1L;

        public AccessLevel(String string) {
            super(string);
        }
    }
}

