/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import java.util.regex.Pattern;

public class Regex {
    private static final String UNICODE_SPACES = "[\\u0009-\\u000d\\u0020\\u0085\\u00a0\\u1680\\u180E\\u2000-\\u200a\\u2028\\u2029\\u202F\\u205F\\u3000]";
    private static String LATIN_ACCENTS_CHARS = "\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u00ff\\u0100-\\u024f\\u0253\\u0254\\u0256\\u0257\\u0259\\u025b\\u0263\\u0268\\u026f\\u0272\\u0289\\u028b\\u02bb\\u0300-\\u036f\\u1e00-\\u1eff";
    private static final String HASHTAG_ALPHA_CHARS = "a-z" + LATIN_ACCENTS_CHARS + "\\u0400-\\u04ff\\u0500-\\u0527\\u2de0-\\u2dff\\ua640-\\ua69f\\u0591-\\u05bf\\u05c1-\\u05c2\\u05c4-\\u05c5\\u05c7\\u05d0-\\u05ea\\u05f0-\\u05f4\\ufb1d-\\ufb28\\ufb2a-\\ufb36\\ufb38-\\ufb3c\\ufb3e\\ufb40-\\ufb41\\ufb43-\\ufb44\\ufb46-\\ufb4f\\u0610-\\u061a\\u0620-\\u065f\\u066e-\\u06d3\\u06d5-\\u06dc\\u06de-\\u06e8\\u06ea-\\u06ef\\u06fa-\\u06fc\\u06ff\\u0750-\\u077f\\u08a0\\u08a2-\\u08ac\\u08e4-\\u08fe\\ufb50-\\ufbb1\\ufbd3-\\ufd3d\\ufd50-\\ufd8f\\ufd92-\\ufdc7\\ufdf0-\\ufdfb\\ufe70-\\ufe74\\ufe76-\\ufefc\\u200c\\u0e01-\\u0e3a\\u0e40-\\u0e4e\\u1100-\\u11ff\\u3130-\\u3185\\uA960-\\uA97F\\uAC00-\\uD7AF\\uD7B0-\\uD7FF\\p{InHiragana}\\p{InKatakana}\\p{InCJKUnifiedIdeographs}\\u3003\\u3005\\u303b\\uff21-\\uff3a\\uff41-\\uff5a\\uff66-\\uff9f\\uffa1-\\uffdc";
    private static final String HASHTAG_ALPHA_NUMERIC_CHARS = "0-9\\uff10-\\uff19_" + HASHTAG_ALPHA_CHARS;
    private static final String HASHTAG_ALPHA = "[" + HASHTAG_ALPHA_CHARS + "]";
    private static final String HASHTAG_ALPHA_NUMERIC = "[" + HASHTAG_ALPHA_NUMERIC_CHARS + "]";
    private static final String URL_VALID_PRECEEDING_CHARS = "(?:[^A-Z0-9/@\uff20$#\uff03\u202a-\u202e]|^)";
    private static final String URL_VALID_CHARS = "[\\p{Alnum}" + LATIN_ACCENTS_CHARS + "]";
    private static final String URL_VALID_SUBDOMAIN = "(?:(?:" + URL_VALID_CHARS + "[" + URL_VALID_CHARS + "\\-_]*)?" + URL_VALID_CHARS + "\\.)";
    private static final String URL_VALID_DOMAIN_NAME = "(?:(?:" + URL_VALID_CHARS + "[" + URL_VALID_CHARS + "\\-]*)?" + URL_VALID_CHARS + "\\.)";
    private static final String URL_VALID_UNICODE_CHARS = "[.[^\\p{Punct}\\s\\p{Z}\\p{InGeneralPunctuation}]]";
    private static final String URL_VALID_GTLD = "(?:(?:\uc0bc\uc131|\ub2f7\ucef4|\ub2f7\ub137|\u9999\u683c\u91cc\u62c9|\u9910\u5385|\u98df\u54c1|\u98de\u5229\u6d66|\u96fb\u8a0a\u76c8\u79d1|\u96c6\u56e2|\u8d2d\u7269|\u8c37\u6b4c|\u8bfa\u57fa\u4e9a|\u8054\u901a|\u7f51\u7edc|\u7f51\u7ad9|\u7f51\u5e97|\u7f51\u5740|\u7ec4\u7ec7\u673a\u6784|\u79fb\u52a8|\u73e0\u5b9d|\u70b9\u770b|\u6e38\u620f|\u6de1\u9a6c\u9521|\u673a\u6784|\u66f8\u7c4d|\u65f6\u5c1a|\u65b0\u95fb|\u653f\u5e9c|\u653f\u52a1|\u624b\u8868|\u624b\u673a|\u6211\u7231\u4f60|\u6148\u5584|\u5fae\u535a|\u5e7f\u4e1c|\u5de5\u884c|\u5bb6\u96fb|\u5a31\u4e50|\u5927\u62ff|\u5728\u7ebf|\u5609\u91cc\u5927\u9152\u5e97|\u5609\u91cc|\u5546\u6807|\u5546\u5e97|\u5546\u57ce|\u516c\u76ca|\u516c\u53f8|\u516b\u5366|\u5065\u5eb7|\u4fe1\u606f|\u4f5b\u5c71|\u4f01\u4e1a|\u4e2d\u6587\u7f51|\u4e2d\u4fe1|\u4e16\u754c|\u30dd\u30a4\u30f3\u30c8|\u30d5\u30a1\u30c3\u30b7\u30e7\u30f3|\u30bb\u30fc\u30eb|\u30b9\u30c8\u30a2|\u30b3\u30e0|\u30b0\u30fc\u30b0\u30eb|\u30af\u30e9\u30a6\u30c9|\u307f\u3093\u306a|\u0e04\u0e2d\u0e21|\u0938\u0902\u0917\u0920\u0928|\u0928\u0947\u091f|\u0915\u0949\u092e|\u0647\u0645\u0631\u0627\u0647|\u0645\u0648\u0642\u0639|\u0645\u0648\u0628\u0627\u064a\u0644\u064a|\u0643\u0648\u0645|\u0634\u0628\u0643\u0629|\u0628\u064a\u062a\u0643|\u0628\u0627\u0632\u0627\u0631|\u0627\u0644\u0639\u0644\u064a\u0627\u0646|\u0627\u0631\u0627\u0645\u0643\u0648|\u0627\u0628\u0648\u0638\u0628\u064a|\u05e7\u05d5\u05dd|\u0441\u0430\u0439\u0442|\u0440\u0443\u0441|\u043e\u0440\u0433|\u043e\u043d\u043b\u0430\u0439\u043d|\u043c\u043e\u0441\u043a\u0432\u0430|\u043a\u043e\u043c|\u0434\u0435\u0442\u0438|zuerich|zone|zippo|zip|zero|zara|zappos|yun|youtube|you|yokohama|yoga|yodobashi|yandex|yamaxun|yahoo|yachts|xyz|xxx|xperia|xin|xihuan|xfinity|xerox|xbox|wtf|wtc|world|works|work|woodside|wolterskluwer|wme|wine|windows|win|williamhill|wiki|wien|whoswho|weir|weibo|wedding|wed|website|weber|webcam|weatherchannel|weather|watches|watch|warman|wanggou|wang|walter|wales|vuelos|voyage|voto|voting|vote|volkswagen|vodka|vlaanderen|viva|vistaprint|vista|vision|virgin|vip|vin|villas|viking|vig|video|viajes|vet|versicherung|verm\u00f6gensberatung|verm\u00f6gensberater|verisign|ventures|vegas|vana|vacations|ups|uol|uno|university|unicom|ubs|tvs|tushu|tunes|tui|tube|trv|trust|travelersinsurance|travelers|travelchannel|travel|training|trading|trade|toys|toyota|town|tours|total|toshiba|toray|top|tools|tokyo|today|tmall|tirol|tires|tips|tiffany|tienda|tickets|theatre|theater|thd|teva|tennis|temasek|telefonica|telecity|tel|technology|tech|team|tdk|tci|taxi|tax|tattoo|tatar|tatamotors|taobao|talk|taipei|tab|systems|symantec|sydney|swiss|swatch|suzuki|surgery|surf|support|supply|supplies|sucks|style|study|studio|stream|store|storage|stockholm|stcgroup|stc|statoil|statefarm|statebank|starhub|star|stada|srl|spreadbetting|spot|spiegel|space|soy|sony|song|solutions|solar|sohu|software|softbank|social|soccer|sncf|smile|skype|sky|skin|ski|site|singles|sina|silk|shriram|show|shouji|shopping|shop|shoes|shiksha|shia|shell|shaw|sharp|shangrila|sfr|sexy|sex|sew|seven|services|sener|select|seek|security|seat|scot|scor|science|schwarz|schule|school|scholarships|schmidt|schaeffler|scb|sca|sbs|sbi|saxo|save|sas|sarl|sapo|sap|sanofi|sandvikcoromant|sandvik|samsung|salon|sale|sakura|safety|safe|saarland|ryukyu|rwe|run|ruhr|rsvp|room|rodeo|rocks|rocher|rip|rio|ricoh|richardli|rich|rexroth|reviews|review|restaurant|rest|republican|report|repair|rentals|rent|ren|reit|reisen|reise|rehab|redumbrella|redstone|red|recipes|realty|realtor|realestate|read|racing|quest|quebec|qpon|pwc|pub|protection|property|properties|promo|progressive|prof|productions|prod|pro|prime|press|praxi|post|porn|politie|poker|pohl|pnc|plus|plumbing|playstation|play|place|pizza|pioneer|pink|ping|pin|pid|pictures|pictet|pics|piaget|physio|photos|photography|photo|philips|pharmacy|pet|pccw|passagens|party|parts|partners|pars|paris|panerai|pamperedchef|page|ovh|ott|otsuka|osaka|origins|orientexpress|organic|org|orange|oracle|ooo|online|onl|ong|one|omega|ollo|olayangroup|olayan|okinawa|office|obi|nyc|ntt|nrw|nra|nowtv|nowruz|now|norton|northwesternmutual|nokia|nissay|nissan|ninja|nikon|nico|nhk|ngo|nfl|nexus|nextdirect|next|news|new|neustar|network|netflix|netbank|net|nec|navy|natura|name|nagoya|nadex|mutuelle|mutual|museum|mtr|mtpc|mtn|movistar|movie|mov|motorcycles|moscow|mortgage|mormon|montblanc|money|monash|mom|moi|moe|moda|mobily|mobi|mma|mls|mlb|mitsubishi|mit|mini|mil|microsoft|miami|metlife|meo|menu|men|memorial|meme|melbourne|meet|media|med|mba|mattel|marriott|markets|marketing|market|mango|management|man|makeup|maison|maif|madrid|luxury|luxe|lupin|ltda|ltd|love|lotto|lotte|london|lol|locus|locker|loans|loan|lixil|living|live|lipsy|link|linde|lincoln|limo|limited|like|lighting|lifestyle|lifeinsurance|life|lidl|liaison|lgbt|lexus|lego|legal|leclerc|lease|lds|lawyer|law|latrobe|lat|lasalle|lanxess|landrover|land|lancaster|lamer|lamborghini|lacaixa|kyoto|kuokgroup|kred|krd|kpn|kpmg|kosher|komatsu|koeln|kiwi|kitchen|kindle|kinder|kim|kia|kfh|kerryproperties|kerrylogistics|kerryhotels|kddi|kaufen|juegos|jprs|jpmorgan|joy|jot|joburg|jobs|jnj|jmp|jll|jlc|jewelry|jetzt|jcp|jcb|java|jaguar|iwc|itv|itau|istanbul|ist|ismaili|iselect|irish|ipiranga|investments|international|int|insure|insurance|institute|ink|ing|info|infiniti|industries|immobilien|immo|imdb|imamat|ikano|iinet|ifm|icu|ice|icbc|ibm|hyundai|htc|hsbc|how|house|hotmail|hoteles|hosting|host|horse|honda|homes|homedepot|holiday|holdings|hockey|hkt|hiv|hitachi|hisamitsu|hiphop|hgtv|hermes|here|helsinki|help|healthcare|health|hdfcbank|haus|hangout|hamburg|guru|guitars|guide|guge|gucci|guardian|group|gripe|green|gratis|graphics|grainger|gov|got|gop|google|goog|goodyear|goo|golf|goldpoint|gold|godaddy|gmx|gmo|gmbh|gmail|globo|global|gle|glass|giving|gives|gifts|gift|ggee|genting|gent|gea|gdn|gbiz|garden|games|game|gallup|gallo|gallery|gal|fyi|futbol|furniture|fund|fujitsu|ftr|frontier|frontdoor|frogans|frl|fresenius|fox|foundation|forum|forsale|forex|ford|football|foodnetwork|foo|fly|flsmidth|flowers|florist|flir|flights|flickr|fitness|fit|fishing|fish|firmdale|firestone|fire|financial|finance|final|film|ferrero|feedback|fedex|fast|fashion|farmers|farm|fans|fan|family|faith|fairwinds|fail|fage|extraspace|express|exposed|expert|exchange|everbank|events|eus|eurovision|estate|esq|erni|ericsson|equipment|epson|epost|enterprises|engineering|engineer|energy|emerck|email|education|edu|edeka|eat|earth|dvag|durban|dupont|dunlop|dubai|dtv|drive|download|dot|doosan|domains|doha|dog|docs|dnp|discount|directory|direct|digital|diet|diamonds|dhl|dev|design|desi|dentist|dental|democrat|delta|deloitte|dell|delivery|degree|deals|dealer|deal|dds|dclk|day|datsun|dating|date|dance|dad|dabur|cyou|cymru|cuisinella|csc|cruises|crs|crown|cricket|creditunion|creditcard|credit|courses|coupons|coupon|country|corsica|coop|cool|cookingchannel|cooking|contractors|contact|consulting|construction|condos|comsec|computer|compare|company|community|commbank|comcast|com|cologne|college|coffee|codes|coach|clubmed|club|cloud|clothing|clinique|clinic|click|cleaning|claims|cityeats|city|citic|cisco|circle|cipriani|church|chrome|christmas|chloe|chintai|cheap|chat|chase|channel|chanel|cfd|cfa|cern|ceo|center|ceb|cbre|cbn|cba|catering|cat|casino|cash|casa|cartier|cars|careers|career|care|cards|caravan|car|capital|capetown|canon|cancerresearch|camp|camera|cam|call|cal|cafe|cab|bzh|buzz|buy|business|builders|build|bugatti|budapest|brussels|brother|broker|broadway|bridgestone|bradesco|boutique|bot|bostik|bosch|boots|book|boo|bond|bom|boehringer|boats|bnpparibas|bnl|bmw|bms|blue|bloomberg|blog|blanco|blackfriday|black|biz|bio|bingo|bing|bike|bid|bible|bharti|bet|best|berlin|bentley|beer|beats|bcn|bcg|bbva|bbc|bayern|bauhaus|bargains|barefoot|barclays|barclaycard|barcelona|bar|bank|band|baidu|baby|azure|axa|aws|avianca|autos|auto|author|audio|audible|audi|auction|attorney|associates|asia|arte|art|arpa|army|archi|aramco|aquarelle|apple|app|apartments|anz|anquan|android|analytics|amsterdam|amica|alstom|alsace|ally|allfinanz|alipay|alibaba|akdn|airtel|airforce|airbus|aig|agency|agakhan|afl|aetna|aero|aeg|adult|ads|adac|actor|active|aco|accountants|accountant|accenture|academy|abudhabi|abogado|able|abbvie|abbott|abb|aarp|aaa|onion)(?=\\P{Alnum}|$))";
    private static final String URL_VALID_CCTLD = "(?:(?:\ud55c\uad6d|\u9999\u6e2f|\u6fb3\u9580|\u65b0\u52a0\u5761|\u53f0\u7063|\u53f0\u6e7e|\u4e2d\u570b|\u4e2d\u56fd|\u10d2\u10d4|\u0e44\u0e17\u0e22|\u0dbd\u0d82\u0d9a\u0dcf|\u0d2d\u0d3e\u0d30\u0d24\u0d02|\u0cad\u0cbe\u0cb0\u0ca4|\u0c2d\u0c3e\u0c30\u0c24\u0c4d|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b2d\u0b3e\u0b30\u0b24|\u0aad\u0abe\u0ab0\u0aa4|\u0a2d\u0a3e\u0a30\u0a24|\u09ad\u09be\u09f0\u09a4|\u09ad\u09be\u09b0\u09a4|\u09ac\u09be\u0982\u09b2\u09be|\u092d\u093e\u0930\u0924|\u067e\u0627\u06a9\u0633\u062a\u0627\u0646|\u0645\u0644\u064a\u0633\u064a\u0627|\u0645\u0635\u0631|\u0642\u0637\u0631|\u0641\u0644\u0633\u0637\u064a\u0646|\u0639\u0645\u0627\u0646|\u0639\u0631\u0627\u0642|\u0633\u0648\u0631\u064a\u0629|\u0633\u0648\u062f\u0627\u0646|\u062a\u0648\u0646\u0633|\u0628\u06be\u0627\u0631\u062a|\u0627\u06cc\u0631\u0627\u0646|\u0627\u0645\u0627\u0631\u0627\u062a|\u0627\u0644\u0645\u063a\u0631\u0628|\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629|\u0627\u0644\u062c\u0632\u0627\u0626\u0631|\u0627\u0644\u0627\u0631\u062f\u0646|\u0570\u0561\u0575|\u049b\u0430\u0437|\u0443\u043a\u0440|\u0441\u0440\u0431|\u0440\u0444|\u043c\u043e\u043d|\u043c\u043a\u0434|\u0435\u044e|\u0431\u0435\u043b|\u0431\u0433|\u03b5\u03bb|zw|zm|za|yt|ye|ws|wf|vu|vn|vi|vg|ve|vc|va|uz|uy|us|um|uk|ug|ua|tz|tw|tv|tt|tr|tp|to|tn|tm|tl|tk|tj|th|tg|tf|td|tc|sz|sy|sx|sv|su|st|ss|sr|so|sn|sm|sl|sk|sj|si|sh|sg|se|sd|sc|sb|sa|rw|ru|rs|ro|re|qa|py|pw|pt|ps|pr|pn|pm|pl|pk|ph|pg|pf|pe|pa|om|nz|nu|nr|np|no|nl|ni|ng|nf|ne|nc|na|mz|my|mx|mw|mv|mu|mt|ms|mr|mq|mp|mo|mn|mm|ml|mk|mh|mg|mf|me|md|mc|ma|ly|lv|lu|lt|ls|lr|lk|li|lc|lb|la|kz|ky|kw|kr|kp|kn|km|ki|kh|kg|ke|jp|jo|jm|je|it|is|ir|iq|io|in|im|il|ie|id|hu|ht|hr|hn|hm|hk|gy|gw|gu|gt|gs|gr|gq|gp|gn|gm|gl|gi|gh|gg|gf|ge|gd|gb|ga|fr|fo|fm|fk|fj|fi|eu|et|es|er|eh|eg|ee|ec|dz|do|dm|dk|dj|de|cz|cy|cx|cw|cv|cu|cr|co|cn|cm|cl|ck|ci|ch|cg|cf|cd|cc|ca|bz|by|bw|bv|bt|bs|br|bq|bo|bn|bm|bl|bj|bi|bh|bg|bf|be|bd|bb|ba|az|ax|aw|au|at|as|ar|aq|ao|an|am|al|ai|ag|af|ae|ad|ac)(?=\\P{Alnum}|$))";
    private static final String URL_PUNYCODE = "(?:xn--[0-9a-z]+)";
    private static final String URL_VALID_DOMAIN = "(?:" + URL_VALID_SUBDOMAIN + "+" + URL_VALID_DOMAIN_NAME + "(?:(?:(?:\uc0bc\uc131|\ub2f7\ucef4|\ub2f7\ub137|\u9999\u683c\u91cc\u62c9|\u9910\u5385|\u98df\u54c1|\u98de\u5229\u6d66|\u96fb\u8a0a\u76c8\u79d1|\u96c6\u56e2|\u8d2d\u7269|\u8c37\u6b4c|\u8bfa\u57fa\u4e9a|\u8054\u901a|\u7f51\u7edc|\u7f51\u7ad9|\u7f51\u5e97|\u7f51\u5740|\u7ec4\u7ec7\u673a\u6784|\u79fb\u52a8|\u73e0\u5b9d|\u70b9\u770b|\u6e38\u620f|\u6de1\u9a6c\u9521|\u673a\u6784|\u66f8\u7c4d|\u65f6\u5c1a|\u65b0\u95fb|\u653f\u5e9c|\u653f\u52a1|\u624b\u8868|\u624b\u673a|\u6211\u7231\u4f60|\u6148\u5584|\u5fae\u535a|\u5e7f\u4e1c|\u5de5\u884c|\u5bb6\u96fb|\u5a31\u4e50|\u5927\u62ff|\u5728\u7ebf|\u5609\u91cc\u5927\u9152\u5e97|\u5609\u91cc|\u5546\u6807|\u5546\u5e97|\u5546\u57ce|\u516c\u76ca|\u516c\u53f8|\u516b\u5366|\u5065\u5eb7|\u4fe1\u606f|\u4f5b\u5c71|\u4f01\u4e1a|\u4e2d\u6587\u7f51|\u4e2d\u4fe1|\u4e16\u754c|\u30dd\u30a4\u30f3\u30c8|\u30d5\u30a1\u30c3\u30b7\u30e7\u30f3|\u30bb\u30fc\u30eb|\u30b9\u30c8\u30a2|\u30b3\u30e0|\u30b0\u30fc\u30b0\u30eb|\u30af\u30e9\u30a6\u30c9|\u307f\u3093\u306a|\u0e04\u0e2d\u0e21|\u0938\u0902\u0917\u0920\u0928|\u0928\u0947\u091f|\u0915\u0949\u092e|\u0647\u0645\u0631\u0627\u0647|\u0645\u0648\u0642\u0639|\u0645\u0648\u0628\u0627\u064a\u0644\u064a|\u0643\u0648\u0645|\u0634\u0628\u0643\u0629|\u0628\u064a\u062a\u0643|\u0628\u0627\u0632\u0627\u0631|\u0627\u0644\u0639\u0644\u064a\u0627\u0646|\u0627\u0631\u0627\u0645\u0643\u0648|\u0627\u0628\u0648\u0638\u0628\u064a|\u05e7\u05d5\u05dd|\u0441\u0430\u0439\u0442|\u0440\u0443\u0441|\u043e\u0440\u0433|\u043e\u043d\u043b\u0430\u0439\u043d|\u043c\u043e\u0441\u043a\u0432\u0430|\u043a\u043e\u043c|\u0434\u0435\u0442\u0438|zuerich|zone|zippo|zip|zero|zara|zappos|yun|youtube|you|yokohama|yoga|yodobashi|yandex|yamaxun|yahoo|yachts|xyz|xxx|xperia|xin|xihuan|xfinity|xerox|xbox|wtf|wtc|world|works|work|woodside|wolterskluwer|wme|wine|windows|win|williamhill|wiki|wien|whoswho|weir|weibo|wedding|wed|website|weber|webcam|weatherchannel|weather|watches|watch|warman|wanggou|wang|walter|wales|vuelos|voyage|voto|voting|vote|volkswagen|vodka|vlaanderen|viva|vistaprint|vista|vision|virgin|vip|vin|villas|viking|vig|video|viajes|vet|versicherung|verm\u00f6gensberatung|verm\u00f6gensberater|verisign|ventures|vegas|vana|vacations|ups|uol|uno|university|unicom|ubs|tvs|tushu|tunes|tui|tube|trv|trust|travelersinsurance|travelers|travelchannel|travel|training|trading|trade|toys|toyota|town|tours|total|toshiba|toray|top|tools|tokyo|today|tmall|tirol|tires|tips|tiffany|tienda|tickets|theatre|theater|thd|teva|tennis|temasek|telefonica|telecity|tel|technology|tech|team|tdk|tci|taxi|tax|tattoo|tatar|tatamotors|taobao|talk|taipei|tab|systems|symantec|sydney|swiss|swatch|suzuki|surgery|surf|support|supply|supplies|sucks|style|study|studio|stream|store|storage|stockholm|stcgroup|stc|statoil|statefarm|statebank|starhub|star|stada|srl|spreadbetting|spot|spiegel|space|soy|sony|song|solutions|solar|sohu|software|softbank|social|soccer|sncf|smile|skype|sky|skin|ski|site|singles|sina|silk|shriram|show|shouji|shopping|shop|shoes|shiksha|shia|shell|shaw|sharp|shangrila|sfr|sexy|sex|sew|seven|services|sener|select|seek|security|seat|scot|scor|science|schwarz|schule|school|scholarships|schmidt|schaeffler|scb|sca|sbs|sbi|saxo|save|sas|sarl|sapo|sap|sanofi|sandvikcoromant|sandvik|samsung|salon|sale|sakura|safety|safe|saarland|ryukyu|rwe|run|ruhr|rsvp|room|rodeo|rocks|rocher|rip|rio|ricoh|richardli|rich|rexroth|reviews|review|restaurant|rest|republican|report|repair|rentals|rent|ren|reit|reisen|reise|rehab|redumbrella|redstone|red|recipes|realty|realtor|realestate|read|racing|quest|quebec|qpon|pwc|pub|protection|property|properties|promo|progressive|prof|productions|prod|pro|prime|press|praxi|post|porn|politie|poker|pohl|pnc|plus|plumbing|playstation|play|place|pizza|pioneer|pink|ping|pin|pid|pictures|pictet|pics|piaget|physio|photos|photography|photo|philips|pharmacy|pet|pccw|passagens|party|parts|partners|pars|paris|panerai|pamperedchef|page|ovh|ott|otsuka|osaka|origins|orientexpress|organic|org|orange|oracle|ooo|online|onl|ong|one|omega|ollo|olayangroup|olayan|okinawa|office|obi|nyc|ntt|nrw|nra|nowtv|nowruz|now|norton|northwesternmutual|nokia|nissay|nissan|ninja|nikon|nico|nhk|ngo|nfl|nexus|nextdirect|next|news|new|neustar|network|netflix|netbank|net|nec|navy|natura|name|nagoya|nadex|mutuelle|mutual|museum|mtr|mtpc|mtn|movistar|movie|mov|motorcycles|moscow|mortgage|mormon|montblanc|money|monash|mom|moi|moe|moda|mobily|mobi|mma|mls|mlb|mitsubishi|mit|mini|mil|microsoft|miami|metlife|meo|menu|men|memorial|meme|melbourne|meet|media|med|mba|mattel|marriott|markets|marketing|market|mango|management|man|makeup|maison|maif|madrid|luxury|luxe|lupin|ltda|ltd|love|lotto|lotte|london|lol|locus|locker|loans|loan|lixil|living|live|lipsy|link|linde|lincoln|limo|limited|like|lighting|lifestyle|lifeinsurance|life|lidl|liaison|lgbt|lexus|lego|legal|leclerc|lease|lds|lawyer|law|latrobe|lat|lasalle|lanxess|landrover|land|lancaster|lamer|lamborghini|lacaixa|kyoto|kuokgroup|kred|krd|kpn|kpmg|kosher|komatsu|koeln|kiwi|kitchen|kindle|kinder|kim|kia|kfh|kerryproperties|kerrylogistics|kerryhotels|kddi|kaufen|juegos|jprs|jpmorgan|joy|jot|joburg|jobs|jnj|jmp|jll|jlc|jewelry|jetzt|jcp|jcb|java|jaguar|iwc|itv|itau|istanbul|ist|ismaili|iselect|irish|ipiranga|investments|international|int|insure|insurance|institute|ink|ing|info|infiniti|industries|immobilien|immo|imdb|imamat|ikano|iinet|ifm|icu|ice|icbc|ibm|hyundai|htc|hsbc|how|house|hotmail|hoteles|hosting|host|horse|honda|homes|homedepot|holiday|holdings|hockey|hkt|hiv|hitachi|hisamitsu|hiphop|hgtv|hermes|here|helsinki|help|healthcare|health|hdfcbank|haus|hangout|hamburg|guru|guitars|guide|guge|gucci|guardian|group|gripe|green|gratis|graphics|grainger|gov|got|gop|google|goog|goodyear|goo|golf|goldpoint|gold|godaddy|gmx|gmo|gmbh|gmail|globo|global|gle|glass|giving|gives|gifts|gift|ggee|genting|gent|gea|gdn|gbiz|garden|games|game|gallup|gallo|gallery|gal|fyi|futbol|furniture|fund|fujitsu|ftr|frontier|frontdoor|frogans|frl|fresenius|fox|foundation|forum|forsale|forex|ford|football|foodnetwork|foo|fly|flsmidth|flowers|florist|flir|flights|flickr|fitness|fit|fishing|fish|firmdale|firestone|fire|financial|finance|final|film|ferrero|feedback|fedex|fast|fashion|farmers|farm|fans|fan|family|faith|fairwinds|fail|fage|extraspace|express|exposed|expert|exchange|everbank|events|eus|eurovision|estate|esq|erni|ericsson|equipment|epson|epost|enterprises|engineering|engineer|energy|emerck|email|education|edu|edeka|eat|earth|dvag|durban|dupont|dunlop|dubai|dtv|drive|download|dot|doosan|domains|doha|dog|docs|dnp|discount|directory|direct|digital|diet|diamonds|dhl|dev|design|desi|dentist|dental|democrat|delta|deloitte|dell|delivery|degree|deals|dealer|deal|dds|dclk|day|datsun|dating|date|dance|dad|dabur|cyou|cymru|cuisinella|csc|cruises|crs|crown|cricket|creditunion|creditcard|credit|courses|coupons|coupon|country|corsica|coop|cool|cookingchannel|cooking|contractors|contact|consulting|construction|condos|comsec|computer|compare|company|community|commbank|comcast|com|cologne|college|coffee|codes|coach|clubmed|club|cloud|clothing|clinique|clinic|click|cleaning|claims|cityeats|city|citic|cisco|circle|cipriani|church|chrome|christmas|chloe|chintai|cheap|chat|chase|channel|chanel|cfd|cfa|cern|ceo|center|ceb|cbre|cbn|cba|catering|cat|casino|cash|casa|cartier|cars|careers|career|care|cards|caravan|car|capital|capetown|canon|cancerresearch|camp|camera|cam|call|cal|cafe|cab|bzh|buzz|buy|business|builders|build|bugatti|budapest|brussels|brother|broker|broadway|bridgestone|bradesco|boutique|bot|bostik|bosch|boots|book|boo|bond|bom|boehringer|boats|bnpparibas|bnl|bmw|bms|blue|bloomberg|blog|blanco|blackfriday|black|biz|bio|bingo|bing|bike|bid|bible|bharti|bet|best|berlin|bentley|beer|beats|bcn|bcg|bbva|bbc|bayern|bauhaus|bargains|barefoot|barclays|barclaycard|barcelona|bar|bank|band|baidu|baby|azure|axa|aws|avianca|autos|auto|author|audio|audible|audi|auction|attorney|associates|asia|arte|art|arpa|army|archi|aramco|aquarelle|apple|app|apartments|anz|anquan|android|analytics|amsterdam|amica|alstom|alsace|ally|allfinanz|alipay|alibaba|akdn|airtel|airforce|airbus|aig|agency|agakhan|afl|aetna|aero|aeg|adult|ads|adac|actor|active|aco|accountants|accountant|accenture|academy|abudhabi|abogado|able|abbvie|abbott|abb|aarp|aaa|onion)(?=\\P{Alnum}|$))|(?:(?:\ud55c\uad6d|\u9999\u6e2f|\u6fb3\u9580|\u65b0\u52a0\u5761|\u53f0\u7063|\u53f0\u6e7e|\u4e2d\u570b|\u4e2d\u56fd|\u10d2\u10d4|\u0e44\u0e17\u0e22|\u0dbd\u0d82\u0d9a\u0dcf|\u0d2d\u0d3e\u0d30\u0d24\u0d02|\u0cad\u0cbe\u0cb0\u0ca4|\u0c2d\u0c3e\u0c30\u0c24\u0c4d|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b2d\u0b3e\u0b30\u0b24|\u0aad\u0abe\u0ab0\u0aa4|\u0a2d\u0a3e\u0a30\u0a24|\u09ad\u09be\u09f0\u09a4|\u09ad\u09be\u09b0\u09a4|\u09ac\u09be\u0982\u09b2\u09be|\u092d\u093e\u0930\u0924|\u067e\u0627\u06a9\u0633\u062a\u0627\u0646|\u0645\u0644\u064a\u0633\u064a\u0627|\u0645\u0635\u0631|\u0642\u0637\u0631|\u0641\u0644\u0633\u0637\u064a\u0646|\u0639\u0645\u0627\u0646|\u0639\u0631\u0627\u0642|\u0633\u0648\u0631\u064a\u0629|\u0633\u0648\u062f\u0627\u0646|\u062a\u0648\u0646\u0633|\u0628\u06be\u0627\u0631\u062a|\u0627\u06cc\u0631\u0627\u0646|\u0627\u0645\u0627\u0631\u0627\u062a|\u0627\u0644\u0645\u063a\u0631\u0628|\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629|\u0627\u0644\u062c\u0632\u0627\u0626\u0631|\u0627\u0644\u0627\u0631\u062f\u0646|\u0570\u0561\u0575|\u049b\u0430\u0437|\u0443\u043a\u0440|\u0441\u0440\u0431|\u0440\u0444|\u043c\u043e\u043d|\u043c\u043a\u0434|\u0435\u044e|\u0431\u0435\u043b|\u0431\u0433|\u03b5\u03bb|zw|zm|za|yt|ye|ws|wf|vu|vn|vi|vg|ve|vc|va|uz|uy|us|um|uk|ug|ua|tz|tw|tv|tt|tr|tp|to|tn|tm|tl|tk|tj|th|tg|tf|td|tc|sz|sy|sx|sv|su|st|ss|sr|so|sn|sm|sl|sk|sj|si|sh|sg|se|sd|sc|sb|sa|rw|ru|rs|ro|re|qa|py|pw|pt|ps|pr|pn|pm|pl|pk|ph|pg|pf|pe|pa|om|nz|nu|nr|np|no|nl|ni|ng|nf|ne|nc|na|mz|my|mx|mw|mv|mu|mt|ms|mr|mq|mp|mo|mn|mm|ml|mk|mh|mg|mf|me|md|mc|ma|ly|lv|lu|lt|ls|lr|lk|li|lc|lb|la|kz|ky|kw|kr|kp|kn|km|ki|kh|kg|ke|jp|jo|jm|je|it|is|ir|iq|io|in|im|il|ie|id|hu|ht|hr|hn|hm|hk|gy|gw|gu|gt|gs|gr|gq|gp|gn|gm|gl|gi|gh|gg|gf|ge|gd|gb|ga|fr|fo|fm|fk|fj|fi|eu|et|es|er|eh|eg|ee|ec|dz|do|dm|dk|dj|de|cz|cy|cx|cw|cv|cu|cr|co|cn|cm|cl|ck|ci|ch|cg|cf|cd|cc|ca|bz|by|bw|bv|bt|bs|br|bq|bo|bn|bm|bl|bj|bi|bh|bg|bf|be|bd|bb|ba|az|ax|aw|au|at|as|ar|aq|ao|an|am|al|ai|ag|af|ae|ad|ac)(?=\\P{Alnum}|$))|(?:xn--[0-9a-z]+)))|(?:" + URL_VALID_DOMAIN_NAME + "(?:(?:(?:\uc0bc\uc131|\ub2f7\ucef4|\ub2f7\ub137|\u9999\u683c\u91cc\u62c9|\u9910\u5385|\u98df\u54c1|\u98de\u5229\u6d66|\u96fb\u8a0a\u76c8\u79d1|\u96c6\u56e2|\u8d2d\u7269|\u8c37\u6b4c|\u8bfa\u57fa\u4e9a|\u8054\u901a|\u7f51\u7edc|\u7f51\u7ad9|\u7f51\u5e97|\u7f51\u5740|\u7ec4\u7ec7\u673a\u6784|\u79fb\u52a8|\u73e0\u5b9d|\u70b9\u770b|\u6e38\u620f|\u6de1\u9a6c\u9521|\u673a\u6784|\u66f8\u7c4d|\u65f6\u5c1a|\u65b0\u95fb|\u653f\u5e9c|\u653f\u52a1|\u624b\u8868|\u624b\u673a|\u6211\u7231\u4f60|\u6148\u5584|\u5fae\u535a|\u5e7f\u4e1c|\u5de5\u884c|\u5bb6\u96fb|\u5a31\u4e50|\u5927\u62ff|\u5728\u7ebf|\u5609\u91cc\u5927\u9152\u5e97|\u5609\u91cc|\u5546\u6807|\u5546\u5e97|\u5546\u57ce|\u516c\u76ca|\u516c\u53f8|\u516b\u5366|\u5065\u5eb7|\u4fe1\u606f|\u4f5b\u5c71|\u4f01\u4e1a|\u4e2d\u6587\u7f51|\u4e2d\u4fe1|\u4e16\u754c|\u30dd\u30a4\u30f3\u30c8|\u30d5\u30a1\u30c3\u30b7\u30e7\u30f3|\u30bb\u30fc\u30eb|\u30b9\u30c8\u30a2|\u30b3\u30e0|\u30b0\u30fc\u30b0\u30eb|\u30af\u30e9\u30a6\u30c9|\u307f\u3093\u306a|\u0e04\u0e2d\u0e21|\u0938\u0902\u0917\u0920\u0928|\u0928\u0947\u091f|\u0915\u0949\u092e|\u0647\u0645\u0631\u0627\u0647|\u0645\u0648\u0642\u0639|\u0645\u0648\u0628\u0627\u064a\u0644\u064a|\u0643\u0648\u0645|\u0634\u0628\u0643\u0629|\u0628\u064a\u062a\u0643|\u0628\u0627\u0632\u0627\u0631|\u0627\u0644\u0639\u0644\u064a\u0627\u0646|\u0627\u0631\u0627\u0645\u0643\u0648|\u0627\u0628\u0648\u0638\u0628\u064a|\u05e7\u05d5\u05dd|\u0441\u0430\u0439\u0442|\u0440\u0443\u0441|\u043e\u0440\u0433|\u043e\u043d\u043b\u0430\u0439\u043d|\u043c\u043e\u0441\u043a\u0432\u0430|\u043a\u043e\u043c|\u0434\u0435\u0442\u0438|zuerich|zone|zippo|zip|zero|zara|zappos|yun|youtube|you|yokohama|yoga|yodobashi|yandex|yamaxun|yahoo|yachts|xyz|xxx|xperia|xin|xihuan|xfinity|xerox|xbox|wtf|wtc|world|works|work|woodside|wolterskluwer|wme|wine|windows|win|williamhill|wiki|wien|whoswho|weir|weibo|wedding|wed|website|weber|webcam|weatherchannel|weather|watches|watch|warman|wanggou|wang|walter|wales|vuelos|voyage|voto|voting|vote|volkswagen|vodka|vlaanderen|viva|vistaprint|vista|vision|virgin|vip|vin|villas|viking|vig|video|viajes|vet|versicherung|verm\u00f6gensberatung|verm\u00f6gensberater|verisign|ventures|vegas|vana|vacations|ups|uol|uno|university|unicom|ubs|tvs|tushu|tunes|tui|tube|trv|trust|travelersinsurance|travelers|travelchannel|travel|training|trading|trade|toys|toyota|town|tours|total|toshiba|toray|top|tools|tokyo|today|tmall|tirol|tires|tips|tiffany|tienda|tickets|theatre|theater|thd|teva|tennis|temasek|telefonica|telecity|tel|technology|tech|team|tdk|tci|taxi|tax|tattoo|tatar|tatamotors|taobao|talk|taipei|tab|systems|symantec|sydney|swiss|swatch|suzuki|surgery|surf|support|supply|supplies|sucks|style|study|studio|stream|store|storage|stockholm|stcgroup|stc|statoil|statefarm|statebank|starhub|star|stada|srl|spreadbetting|spot|spiegel|space|soy|sony|song|solutions|solar|sohu|software|softbank|social|soccer|sncf|smile|skype|sky|skin|ski|site|singles|sina|silk|shriram|show|shouji|shopping|shop|shoes|shiksha|shia|shell|shaw|sharp|shangrila|sfr|sexy|sex|sew|seven|services|sener|select|seek|security|seat|scot|scor|science|schwarz|schule|school|scholarships|schmidt|schaeffler|scb|sca|sbs|sbi|saxo|save|sas|sarl|sapo|sap|sanofi|sandvikcoromant|sandvik|samsung|salon|sale|sakura|safety|safe|saarland|ryukyu|rwe|run|ruhr|rsvp|room|rodeo|rocks|rocher|rip|rio|ricoh|richardli|rich|rexroth|reviews|review|restaurant|rest|republican|report|repair|rentals|rent|ren|reit|reisen|reise|rehab|redumbrella|redstone|red|recipes|realty|realtor|realestate|read|racing|quest|quebec|qpon|pwc|pub|protection|property|properties|promo|progressive|prof|productions|prod|pro|prime|press|praxi|post|porn|politie|poker|pohl|pnc|plus|plumbing|playstation|play|place|pizza|pioneer|pink|ping|pin|pid|pictures|pictet|pics|piaget|physio|photos|photography|photo|philips|pharmacy|pet|pccw|passagens|party|parts|partners|pars|paris|panerai|pamperedchef|page|ovh|ott|otsuka|osaka|origins|orientexpress|organic|org|orange|oracle|ooo|online|onl|ong|one|omega|ollo|olayangroup|olayan|okinawa|office|obi|nyc|ntt|nrw|nra|nowtv|nowruz|now|norton|northwesternmutual|nokia|nissay|nissan|ninja|nikon|nico|nhk|ngo|nfl|nexus|nextdirect|next|news|new|neustar|network|netflix|netbank|net|nec|navy|natura|name|nagoya|nadex|mutuelle|mutual|museum|mtr|mtpc|mtn|movistar|movie|mov|motorcycles|moscow|mortgage|mormon|montblanc|money|monash|mom|moi|moe|moda|mobily|mobi|mma|mls|mlb|mitsubishi|mit|mini|mil|microsoft|miami|metlife|meo|menu|men|memorial|meme|melbourne|meet|media|med|mba|mattel|marriott|markets|marketing|market|mango|management|man|makeup|maison|maif|madrid|luxury|luxe|lupin|ltda|ltd|love|lotto|lotte|london|lol|locus|locker|loans|loan|lixil|living|live|lipsy|link|linde|lincoln|limo|limited|like|lighting|lifestyle|lifeinsurance|life|lidl|liaison|lgbt|lexus|lego|legal|leclerc|lease|lds|lawyer|law|latrobe|lat|lasalle|lanxess|landrover|land|lancaster|lamer|lamborghini|lacaixa|kyoto|kuokgroup|kred|krd|kpn|kpmg|kosher|komatsu|koeln|kiwi|kitchen|kindle|kinder|kim|kia|kfh|kerryproperties|kerrylogistics|kerryhotels|kddi|kaufen|juegos|jprs|jpmorgan|joy|jot|joburg|jobs|jnj|jmp|jll|jlc|jewelry|jetzt|jcp|jcb|java|jaguar|iwc|itv|itau|istanbul|ist|ismaili|iselect|irish|ipiranga|investments|international|int|insure|insurance|institute|ink|ing|info|infiniti|industries|immobilien|immo|imdb|imamat|ikano|iinet|ifm|icu|ice|icbc|ibm|hyundai|htc|hsbc|how|house|hotmail|hoteles|hosting|host|horse|honda|homes|homedepot|holiday|holdings|hockey|hkt|hiv|hitachi|hisamitsu|hiphop|hgtv|hermes|here|helsinki|help|healthcare|health|hdfcbank|haus|hangout|hamburg|guru|guitars|guide|guge|gucci|guardian|group|gripe|green|gratis|graphics|grainger|gov|got|gop|google|goog|goodyear|goo|golf|goldpoint|gold|godaddy|gmx|gmo|gmbh|gmail|globo|global|gle|glass|giving|gives|gifts|gift|ggee|genting|gent|gea|gdn|gbiz|garden|games|game|gallup|gallo|gallery|gal|fyi|futbol|furniture|fund|fujitsu|ftr|frontier|frontdoor|frogans|frl|fresenius|fox|foundation|forum|forsale|forex|ford|football|foodnetwork|foo|fly|flsmidth|flowers|florist|flir|flights|flickr|fitness|fit|fishing|fish|firmdale|firestone|fire|financial|finance|final|film|ferrero|feedback|fedex|fast|fashion|farmers|farm|fans|fan|family|faith|fairwinds|fail|fage|extraspace|express|exposed|expert|exchange|everbank|events|eus|eurovision|estate|esq|erni|ericsson|equipment|epson|epost|enterprises|engineering|engineer|energy|emerck|email|education|edu|edeka|eat|earth|dvag|durban|dupont|dunlop|dubai|dtv|drive|download|dot|doosan|domains|doha|dog|docs|dnp|discount|directory|direct|digital|diet|diamonds|dhl|dev|design|desi|dentist|dental|democrat|delta|deloitte|dell|delivery|degree|deals|dealer|deal|dds|dclk|day|datsun|dating|date|dance|dad|dabur|cyou|cymru|cuisinella|csc|cruises|crs|crown|cricket|creditunion|creditcard|credit|courses|coupons|coupon|country|corsica|coop|cool|cookingchannel|cooking|contractors|contact|consulting|construction|condos|comsec|computer|compare|company|community|commbank|comcast|com|cologne|college|coffee|codes|coach|clubmed|club|cloud|clothing|clinique|clinic|click|cleaning|claims|cityeats|city|citic|cisco|circle|cipriani|church|chrome|christmas|chloe|chintai|cheap|chat|chase|channel|chanel|cfd|cfa|cern|ceo|center|ceb|cbre|cbn|cba|catering|cat|casino|cash|casa|cartier|cars|careers|career|care|cards|caravan|car|capital|capetown|canon|cancerresearch|camp|camera|cam|call|cal|cafe|cab|bzh|buzz|buy|business|builders|build|bugatti|budapest|brussels|brother|broker|broadway|bridgestone|bradesco|boutique|bot|bostik|bosch|boots|book|boo|bond|bom|boehringer|boats|bnpparibas|bnl|bmw|bms|blue|bloomberg|blog|blanco|blackfriday|black|biz|bio|bingo|bing|bike|bid|bible|bharti|bet|best|berlin|bentley|beer|beats|bcn|bcg|bbva|bbc|bayern|bauhaus|bargains|barefoot|barclays|barclaycard|barcelona|bar|bank|band|baidu|baby|azure|axa|aws|avianca|autos|auto|author|audio|audible|audi|auction|attorney|associates|asia|arte|art|arpa|army|archi|aramco|aquarelle|apple|app|apartments|anz|anquan|android|analytics|amsterdam|amica|alstom|alsace|ally|allfinanz|alipay|alibaba|akdn|airtel|airforce|airbus|aig|agency|agakhan|afl|aetna|aero|aeg|adult|ads|adac|actor|active|aco|accountants|accountant|accenture|academy|abudhabi|abogado|able|abbvie|abbott|abb|aarp|aaa|onion)(?=\\P{Alnum}|$))|(?:xn--[0-9a-z]+)))|(?:(?<=https?://)(?:(?:" + URL_VALID_DOMAIN_NAME + "(?:(?:\ud55c\uad6d|\u9999\u6e2f|\u6fb3\u9580|\u65b0\u52a0\u5761|\u53f0\u7063|\u53f0\u6e7e|\u4e2d\u570b|\u4e2d\u56fd|\u10d2\u10d4|\u0e44\u0e17\u0e22|\u0dbd\u0d82\u0d9a\u0dcf|\u0d2d\u0d3e\u0d30\u0d24\u0d02|\u0cad\u0cbe\u0cb0\u0ca4|\u0c2d\u0c3e\u0c30\u0c24\u0c4d|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b2d\u0b3e\u0b30\u0b24|\u0aad\u0abe\u0ab0\u0aa4|\u0a2d\u0a3e\u0a30\u0a24|\u09ad\u09be\u09f0\u09a4|\u09ad\u09be\u09b0\u09a4|\u09ac\u09be\u0982\u09b2\u09be|\u092d\u093e\u0930\u0924|\u067e\u0627\u06a9\u0633\u062a\u0627\u0646|\u0645\u0644\u064a\u0633\u064a\u0627|\u0645\u0635\u0631|\u0642\u0637\u0631|\u0641\u0644\u0633\u0637\u064a\u0646|\u0639\u0645\u0627\u0646|\u0639\u0631\u0627\u0642|\u0633\u0648\u0631\u064a\u0629|\u0633\u0648\u062f\u0627\u0646|\u062a\u0648\u0646\u0633|\u0628\u06be\u0627\u0631\u062a|\u0627\u06cc\u0631\u0627\u0646|\u0627\u0645\u0627\u0631\u0627\u062a|\u0627\u0644\u0645\u063a\u0631\u0628|\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629|\u0627\u0644\u062c\u0632\u0627\u0626\u0631|\u0627\u0644\u0627\u0631\u062f\u0646|\u0570\u0561\u0575|\u049b\u0430\u0437|\u0443\u043a\u0440|\u0441\u0440\u0431|\u0440\u0444|\u043c\u043e\u043d|\u043c\u043a\u0434|\u0435\u044e|\u0431\u0435\u043b|\u0431\u0433|\u03b5\u03bb|zw|zm|za|yt|ye|ws|wf|vu|vn|vi|vg|ve|vc|va|uz|uy|us|um|uk|ug|ua|tz|tw|tv|tt|tr|tp|to|tn|tm|tl|tk|tj|th|tg|tf|td|tc|sz|sy|sx|sv|su|st|ss|sr|so|sn|sm|sl|sk|sj|si|sh|sg|se|sd|sc|sb|sa|rw|ru|rs|ro|re|qa|py|pw|pt|ps|pr|pn|pm|pl|pk|ph|pg|pf|pe|pa|om|nz|nu|nr|np|no|nl|ni|ng|nf|ne|nc|na|mz|my|mx|mw|mv|mu|mt|ms|mr|mq|mp|mo|mn|mm|ml|mk|mh|mg|mf|me|md|mc|ma|ly|lv|lu|lt|ls|lr|lk|li|lc|lb|la|kz|ky|kw|kr|kp|kn|km|ki|kh|kg|ke|jp|jo|jm|je|it|is|ir|iq|io|in|im|il|ie|id|hu|ht|hr|hn|hm|hk|gy|gw|gu|gt|gs|gr|gq|gp|gn|gm|gl|gi|gh|gg|gf|ge|gd|gb|ga|fr|fo|fm|fk|fj|fi|eu|et|es|er|eh|eg|ee|ec|dz|do|dm|dk|dj|de|cz|cy|cx|cw|cv|cu|cr|co|cn|cm|cl|ck|ci|ch|cg|cf|cd|cc|ca|bz|by|bw|bv|bt|bs|br|bq|bo|bn|bm|bl|bj|bi|bh|bg|bf|be|bd|bb|ba|az|ax|aw|au|at|as|ar|aq|ao|an|am|al|ai|ag|af|ae|ad|ac)(?=\\P{Alnum}|$)))|(?:[.[^\\p{Punct}\\s\\p{Z}\\p{InGeneralPunctuation}]]+\\.(?:(?:(?:\uc0bc\uc131|\ub2f7\ucef4|\ub2f7\ub137|\u9999\u683c\u91cc\u62c9|\u9910\u5385|\u98df\u54c1|\u98de\u5229\u6d66|\u96fb\u8a0a\u76c8\u79d1|\u96c6\u56e2|\u8d2d\u7269|\u8c37\u6b4c|\u8bfa\u57fa\u4e9a|\u8054\u901a|\u7f51\u7edc|\u7f51\u7ad9|\u7f51\u5e97|\u7f51\u5740|\u7ec4\u7ec7\u673a\u6784|\u79fb\u52a8|\u73e0\u5b9d|\u70b9\u770b|\u6e38\u620f|\u6de1\u9a6c\u9521|\u673a\u6784|\u66f8\u7c4d|\u65f6\u5c1a|\u65b0\u95fb|\u653f\u5e9c|\u653f\u52a1|\u624b\u8868|\u624b\u673a|\u6211\u7231\u4f60|\u6148\u5584|\u5fae\u535a|\u5e7f\u4e1c|\u5de5\u884c|\u5bb6\u96fb|\u5a31\u4e50|\u5927\u62ff|\u5728\u7ebf|\u5609\u91cc\u5927\u9152\u5e97|\u5609\u91cc|\u5546\u6807|\u5546\u5e97|\u5546\u57ce|\u516c\u76ca|\u516c\u53f8|\u516b\u5366|\u5065\u5eb7|\u4fe1\u606f|\u4f5b\u5c71|\u4f01\u4e1a|\u4e2d\u6587\u7f51|\u4e2d\u4fe1|\u4e16\u754c|\u30dd\u30a4\u30f3\u30c8|\u30d5\u30a1\u30c3\u30b7\u30e7\u30f3|\u30bb\u30fc\u30eb|\u30b9\u30c8\u30a2|\u30b3\u30e0|\u30b0\u30fc\u30b0\u30eb|\u30af\u30e9\u30a6\u30c9|\u307f\u3093\u306a|\u0e04\u0e2d\u0e21|\u0938\u0902\u0917\u0920\u0928|\u0928\u0947\u091f|\u0915\u0949\u092e|\u0647\u0645\u0631\u0627\u0647|\u0645\u0648\u0642\u0639|\u0645\u0648\u0628\u0627\u064a\u0644\u064a|\u0643\u0648\u0645|\u0634\u0628\u0643\u0629|\u0628\u064a\u062a\u0643|\u0628\u0627\u0632\u0627\u0631|\u0627\u0644\u0639\u0644\u064a\u0627\u0646|\u0627\u0631\u0627\u0645\u0643\u0648|\u0627\u0628\u0648\u0638\u0628\u064a|\u05e7\u05d5\u05dd|\u0441\u0430\u0439\u0442|\u0440\u0443\u0441|\u043e\u0440\u0433|\u043e\u043d\u043b\u0430\u0439\u043d|\u043c\u043e\u0441\u043a\u0432\u0430|\u043a\u043e\u043c|\u0434\u0435\u0442\u0438|zuerich|zone|zippo|zip|zero|zara|zappos|yun|youtube|you|yokohama|yoga|yodobashi|yandex|yamaxun|yahoo|yachts|xyz|xxx|xperia|xin|xihuan|xfinity|xerox|xbox|wtf|wtc|world|works|work|woodside|wolterskluwer|wme|wine|windows|win|williamhill|wiki|wien|whoswho|weir|weibo|wedding|wed|website|weber|webcam|weatherchannel|weather|watches|watch|warman|wanggou|wang|walter|wales|vuelos|voyage|voto|voting|vote|volkswagen|vodka|vlaanderen|viva|vistaprint|vista|vision|virgin|vip|vin|villas|viking|vig|video|viajes|vet|versicherung|verm\u00f6gensberatung|verm\u00f6gensberater|verisign|ventures|vegas|vana|vacations|ups|uol|uno|university|unicom|ubs|tvs|tushu|tunes|tui|tube|trv|trust|travelersinsurance|travelers|travelchannel|travel|training|trading|trade|toys|toyota|town|tours|total|toshiba|toray|top|tools|tokyo|today|tmall|tirol|tires|tips|tiffany|tienda|tickets|theatre|theater|thd|teva|tennis|temasek|telefonica|telecity|tel|technology|tech|team|tdk|tci|taxi|tax|tattoo|tatar|tatamotors|taobao|talk|taipei|tab|systems|symantec|sydney|swiss|swatch|suzuki|surgery|surf|support|supply|supplies|sucks|style|study|studio|stream|store|storage|stockholm|stcgroup|stc|statoil|statefarm|statebank|starhub|star|stada|srl|spreadbetting|spot|spiegel|space|soy|sony|song|solutions|solar|sohu|software|softbank|social|soccer|sncf|smile|skype|sky|skin|ski|site|singles|sina|silk|shriram|show|shouji|shopping|shop|shoes|shiksha|shia|shell|shaw|sharp|shangrila|sfr|sexy|sex|sew|seven|services|sener|select|seek|security|seat|scot|scor|science|schwarz|schule|school|scholarships|schmidt|schaeffler|scb|sca|sbs|sbi|saxo|save|sas|sarl|sapo|sap|sanofi|sandvikcoromant|sandvik|samsung|salon|sale|sakura|safety|safe|saarland|ryukyu|rwe|run|ruhr|rsvp|room|rodeo|rocks|rocher|rip|rio|ricoh|richardli|rich|rexroth|reviews|review|restaurant|rest|republican|report|repair|rentals|rent|ren|reit|reisen|reise|rehab|redumbrella|redstone|red|recipes|realty|realtor|realestate|read|racing|quest|quebec|qpon|pwc|pub|protection|property|properties|promo|progressive|prof|productions|prod|pro|prime|press|praxi|post|porn|politie|poker|pohl|pnc|plus|plumbing|playstation|play|place|pizza|pioneer|pink|ping|pin|pid|pictures|pictet|pics|piaget|physio|photos|photography|photo|philips|pharmacy|pet|pccw|passagens|party|parts|partners|pars|paris|panerai|pamperedchef|page|ovh|ott|otsuka|osaka|origins|orientexpress|organic|org|orange|oracle|ooo|online|onl|ong|one|omega|ollo|olayangroup|olayan|okinawa|office|obi|nyc|ntt|nrw|nra|nowtv|nowruz|now|norton|northwesternmutual|nokia|nissay|nissan|ninja|nikon|nico|nhk|ngo|nfl|nexus|nextdirect|next|news|new|neustar|network|netflix|netbank|net|nec|navy|natura|name|nagoya|nadex|mutuelle|mutual|museum|mtr|mtpc|mtn|movistar|movie|mov|motorcycles|moscow|mortgage|mormon|montblanc|money|monash|mom|moi|moe|moda|mobily|mobi|mma|mls|mlb|mitsubishi|mit|mini|mil|microsoft|miami|metlife|meo|menu|men|memorial|meme|melbourne|meet|media|med|mba|mattel|marriott|markets|marketing|market|mango|management|man|makeup|maison|maif|madrid|luxury|luxe|lupin|ltda|ltd|love|lotto|lotte|london|lol|locus|locker|loans|loan|lixil|living|live|lipsy|link|linde|lincoln|limo|limited|like|lighting|lifestyle|lifeinsurance|life|lidl|liaison|lgbt|lexus|lego|legal|leclerc|lease|lds|lawyer|law|latrobe|lat|lasalle|lanxess|landrover|land|lancaster|lamer|lamborghini|lacaixa|kyoto|kuokgroup|kred|krd|kpn|kpmg|kosher|komatsu|koeln|kiwi|kitchen|kindle|kinder|kim|kia|kfh|kerryproperties|kerrylogistics|kerryhotels|kddi|kaufen|juegos|jprs|jpmorgan|joy|jot|joburg|jobs|jnj|jmp|jll|jlc|jewelry|jetzt|jcp|jcb|java|jaguar|iwc|itv|itau|istanbul|ist|ismaili|iselect|irish|ipiranga|investments|international|int|insure|insurance|institute|ink|ing|info|infiniti|industries|immobilien|immo|imdb|imamat|ikano|iinet|ifm|icu|ice|icbc|ibm|hyundai|htc|hsbc|how|house|hotmail|hoteles|hosting|host|horse|honda|homes|homedepot|holiday|holdings|hockey|hkt|hiv|hitachi|hisamitsu|hiphop|hgtv|hermes|here|helsinki|help|healthcare|health|hdfcbank|haus|hangout|hamburg|guru|guitars|guide|guge|gucci|guardian|group|gripe|green|gratis|graphics|grainger|gov|got|gop|google|goog|goodyear|goo|golf|goldpoint|gold|godaddy|gmx|gmo|gmbh|gmail|globo|global|gle|glass|giving|gives|gifts|gift|ggee|genting|gent|gea|gdn|gbiz|garden|games|game|gallup|gallo|gallery|gal|fyi|futbol|furniture|fund|fujitsu|ftr|frontier|frontdoor|frogans|frl|fresenius|fox|foundation|forum|forsale|forex|ford|football|foodnetwork|foo|fly|flsmidth|flowers|florist|flir|flights|flickr|fitness|fit|fishing|fish|firmdale|firestone|fire|financial|finance|final|film|ferrero|feedback|fedex|fast|fashion|farmers|farm|fans|fan|family|faith|fairwinds|fail|fage|extraspace|express|exposed|expert|exchange|everbank|events|eus|eurovision|estate|esq|erni|ericsson|equipment|epson|epost|enterprises|engineering|engineer|energy|emerck|email|education|edu|edeka|eat|earth|dvag|durban|dupont|dunlop|dubai|dtv|drive|download|dot|doosan|domains|doha|dog|docs|dnp|discount|directory|direct|digital|diet|diamonds|dhl|dev|design|desi|dentist|dental|democrat|delta|deloitte|dell|delivery|degree|deals|dealer|deal|dds|dclk|day|datsun|dating|date|dance|dad|dabur|cyou|cymru|cuisinella|csc|cruises|crs|crown|cricket|creditunion|creditcard|credit|courses|coupons|coupon|country|corsica|coop|cool|cookingchannel|cooking|contractors|contact|consulting|construction|condos|comsec|computer|compare|company|community|commbank|comcast|com|cologne|college|coffee|codes|coach|clubmed|club|cloud|clothing|clinique|clinic|click|cleaning|claims|cityeats|city|citic|cisco|circle|cipriani|church|chrome|christmas|chloe|chintai|cheap|chat|chase|channel|chanel|cfd|cfa|cern|ceo|center|ceb|cbre|cbn|cba|catering|cat|casino|cash|casa|cartier|cars|careers|career|care|cards|caravan|car|capital|capetown|canon|cancerresearch|camp|camera|cam|call|cal|cafe|cab|bzh|buzz|buy|business|builders|build|bugatti|budapest|brussels|brother|broker|broadway|bridgestone|bradesco|boutique|bot|bostik|bosch|boots|book|boo|bond|bom|boehringer|boats|bnpparibas|bnl|bmw|bms|blue|bloomberg|blog|blanco|blackfriday|black|biz|bio|bingo|bing|bike|bid|bible|bharti|bet|best|berlin|bentley|beer|beats|bcn|bcg|bbva|bbc|bayern|bauhaus|bargains|barefoot|barclays|barclaycard|barcelona|bar|bank|band|baidu|baby|azure|axa|aws|avianca|autos|auto|author|audio|audible|audi|auction|attorney|associates|asia|arte|art|arpa|army|archi|aramco|aquarelle|apple|app|apartments|anz|anquan|android|analytics|amsterdam|amica|alstom|alsace|ally|allfinanz|alipay|alibaba|akdn|airtel|airforce|airbus|aig|agency|agakhan|afl|aetna|aero|aeg|adult|ads|adac|actor|active|aco|accountants|accountant|accenture|academy|abudhabi|abogado|able|abbvie|abbott|abb|aarp|aaa|onion)(?=\\P{Alnum}|$))|(?:(?:\ud55c\uad6d|\u9999\u6e2f|\u6fb3\u9580|\u65b0\u52a0\u5761|\u53f0\u7063|\u53f0\u6e7e|\u4e2d\u570b|\u4e2d\u56fd|\u10d2\u10d4|\u0e44\u0e17\u0e22|\u0dbd\u0d82\u0d9a\u0dcf|\u0d2d\u0d3e\u0d30\u0d24\u0d02|\u0cad\u0cbe\u0cb0\u0ca4|\u0c2d\u0c3e\u0c30\u0c24\u0c4d|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b2d\u0b3e\u0b30\u0b24|\u0aad\u0abe\u0ab0\u0aa4|\u0a2d\u0a3e\u0a30\u0a24|\u09ad\u09be\u09f0\u09a4|\u09ad\u09be\u09b0\u09a4|\u09ac\u09be\u0982\u09b2\u09be|\u092d\u093e\u0930\u0924|\u067e\u0627\u06a9\u0633\u062a\u0627\u0646|\u0645\u0644\u064a\u0633\u064a\u0627|\u0645\u0635\u0631|\u0642\u0637\u0631|\u0641\u0644\u0633\u0637\u064a\u0646|\u0639\u0645\u0627\u0646|\u0639\u0631\u0627\u0642|\u0633\u0648\u0631\u064a\u0629|\u0633\u0648\u062f\u0627\u0646|\u062a\u0648\u0646\u0633|\u0628\u06be\u0627\u0631\u062a|\u0627\u06cc\u0631\u0627\u0646|\u0627\u0645\u0627\u0631\u0627\u062a|\u0627\u0644\u0645\u063a\u0631\u0628|\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629|\u0627\u0644\u062c\u0632\u0627\u0626\u0631|\u0627\u0644\u0627\u0631\u062f\u0646|\u0570\u0561\u0575|\u049b\u0430\u0437|\u0443\u043a\u0440|\u0441\u0440\u0431|\u0440\u0444|\u043c\u043e\u043d|\u043c\u043a\u0434|\u0435\u044e|\u0431\u0435\u043b|\u0431\u0433|\u03b5\u03bb|zw|zm|za|yt|ye|ws|wf|vu|vn|vi|vg|ve|vc|va|uz|uy|us|um|uk|ug|ua|tz|tw|tv|tt|tr|tp|to|tn|tm|tl|tk|tj|th|tg|tf|td|tc|sz|sy|sx|sv|su|st|ss|sr|so|sn|sm|sl|sk|sj|si|sh|sg|se|sd|sc|sb|sa|rw|ru|rs|ro|re|qa|py|pw|pt|ps|pr|pn|pm|pl|pk|ph|pg|pf|pe|pa|om|nz|nu|nr|np|no|nl|ni|ng|nf|ne|nc|na|mz|my|mx|mw|mv|mu|mt|ms|mr|mq|mp|mo|mn|mm|ml|mk|mh|mg|mf|me|md|mc|ma|ly|lv|lu|lt|ls|lr|lk|li|lc|lb|la|kz|ky|kw|kr|kp|kn|km|ki|kh|kg|ke|jp|jo|jm|je|it|is|ir|iq|io|in|im|il|ie|id|hu|ht|hr|hn|hm|hk|gy|gw|gu|gt|gs|gr|gq|gp|gn|gm|gl|gi|gh|gg|gf|ge|gd|gb|ga|fr|fo|fm|fk|fj|fi|eu|et|es|er|eh|eg|ee|ec|dz|do|dm|dk|dj|de|cz|cy|cx|cw|cv|cu|cr|co|cn|cm|cl|ck|ci|ch|cg|cf|cd|cc|ca|bz|by|bw|bv|bt|bs|br|bq|bo|bn|bm|bl|bj|bi|bh|bg|bf|be|bd|bb|ba|az|ax|aw|au|at|as|ar|aq|ao|an|am|al|ai|ag|af|ae|ad|ac)(?=\\P{Alnum}|$))))))|(?:" + URL_VALID_DOMAIN_NAME + "(?:(?:\ud55c\uad6d|\u9999\u6e2f|\u6fb3\u9580|\u65b0\u52a0\u5761|\u53f0\u7063|\u53f0\u6e7e|\u4e2d\u570b|\u4e2d\u56fd|\u10d2\u10d4|\u0e44\u0e17\u0e22|\u0dbd\u0d82\u0d9a\u0dcf|\u0d2d\u0d3e\u0d30\u0d24\u0d02|\u0cad\u0cbe\u0cb0\u0ca4|\u0c2d\u0c3e\u0c30\u0c24\u0c4d|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b2d\u0b3e\u0b30\u0b24|\u0aad\u0abe\u0ab0\u0aa4|\u0a2d\u0a3e\u0a30\u0a24|\u09ad\u09be\u09f0\u09a4|\u09ad\u09be\u09b0\u09a4|\u09ac\u09be\u0982\u09b2\u09be|\u092d\u093e\u0930\u0924|\u067e\u0627\u06a9\u0633\u062a\u0627\u0646|\u0645\u0644\u064a\u0633\u064a\u0627|\u0645\u0635\u0631|\u0642\u0637\u0631|\u0641\u0644\u0633\u0637\u064a\u0646|\u0639\u0645\u0627\u0646|\u0639\u0631\u0627\u0642|\u0633\u0648\u0631\u064a\u0629|\u0633\u0648\u062f\u0627\u0646|\u062a\u0648\u0646\u0633|\u0628\u06be\u0627\u0631\u062a|\u0627\u06cc\u0631\u0627\u0646|\u0627\u0645\u0627\u0631\u0627\u062a|\u0627\u0644\u0645\u063a\u0631\u0628|\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629|\u0627\u0644\u062c\u0632\u0627\u0626\u0631|\u0627\u0644\u0627\u0631\u062f\u0646|\u0570\u0561\u0575|\u049b\u0430\u0437|\u0443\u043a\u0440|\u0441\u0440\u0431|\u0440\u0444|\u043c\u043e\u043d|\u043c\u043a\u0434|\u0435\u044e|\u0431\u0435\u043b|\u0431\u0433|\u03b5\u03bb|zw|zm|za|yt|ye|ws|wf|vu|vn|vi|vg|ve|vc|va|uz|uy|us|um|uk|ug|ua|tz|tw|tv|tt|tr|tp|to|tn|tm|tl|tk|tj|th|tg|tf|td|tc|sz|sy|sx|sv|su|st|ss|sr|so|sn|sm|sl|sk|sj|si|sh|sg|se|sd|sc|sb|sa|rw|ru|rs|ro|re|qa|py|pw|pt|ps|pr|pn|pm|pl|pk|ph|pg|pf|pe|pa|om|nz|nu|nr|np|no|nl|ni|ng|nf|ne|nc|na|mz|my|mx|mw|mv|mu|mt|ms|mr|mq|mp|mo|mn|mm|ml|mk|mh|mg|mf|me|md|mc|ma|ly|lv|lu|lt|ls|lr|lk|li|lc|lb|la|kz|ky|kw|kr|kp|kn|km|ki|kh|kg|ke|jp|jo|jm|je|it|is|ir|iq|io|in|im|il|ie|id|hu|ht|hr|hn|hm|hk|gy|gw|gu|gt|gs|gr|gq|gp|gn|gm|gl|gi|gh|gg|gf|ge|gd|gb|ga|fr|fo|fm|fk|fj|fi|eu|et|es|er|eh|eg|ee|ec|dz|do|dm|dk|dj|de|cz|cy|cx|cw|cv|cu|cr|co|cn|cm|cl|ck|ci|ch|cg|cf|cd|cc|ca|bz|by|bw|bv|bt|bs|br|bq|bo|bn|bm|bl|bj|bi|bh|bg|bf|be|bd|bb|ba|az|ax|aw|au|at|as|ar|aq|ao|an|am|al|ai|ag|af|ae|ad|ac)(?=\\P{Alnum}|$))(?=/))";
    private static final String URL_VALID_PORT_NUMBER = "[0-9]++";
    private static final String URL_VALID_GENERAL_PATH_CHARS = "[a-z0-9!\\*';:=\\+,.\\$/%#\\[\\]\\-_~\\|&@" + LATIN_ACCENTS_CHARS + "]";
    private static final String URL_BALANCED_PARENS = "\\(" + URL_VALID_GENERAL_PATH_CHARS + "+\\)";
    private static final String URL_VALID_PATH_ENDING_CHARS = "[a-z0-9=_#/\\-\\+" + LATIN_ACCENTS_CHARS + "]|(?:" + URL_BALANCED_PARENS + ")";
    private static final String URL_VALID_PATH = "(?:(?:" + URL_VALID_GENERAL_PATH_CHARS + "*(?:" + URL_BALANCED_PARENS + URL_VALID_GENERAL_PATH_CHARS + "*)*" + URL_VALID_PATH_ENDING_CHARS + ")|(?:@" + URL_VALID_GENERAL_PATH_CHARS + "+/))";
    private static final String URL_VALID_URL_QUERY_CHARS = "[a-z0-9!?\\*'\\(\\);:&=\\+\\$/%#\\[\\]\\-_\\.,~\\|@]";
    private static final String URL_VALID_URL_QUERY_ENDING_CHARS = "[a-z0-9_&=#/]";
    private static final String VALID_URL_PATTERN_STRING = "(((?:[^A-Z0-9/@\uff20$#\uff03\u202a-\u202e]|^))((https?://)?(" + URL_VALID_DOMAIN + ")(?::([0-9]++))?(/" + URL_VALID_PATH + "*+)?(\\?[a-z0-9!?\\*'\\(\\);:&=\\+\\$/%#\\[\\]\\-_\\.,~\\|@]*[a-z0-9_&=#/])?))";
    private static String AT_SIGNS_CHARS = "@\uff20";
    private static final String DOLLAR_SIGN_CHAR = "\\$";
    private static final String CASHTAG = "[a-z]{1,6}(?:[._][a-z]{1,2})?";
    public static final Pattern VALID_HASHTAG = Pattern.compile("(^|[^&" + HASHTAG_ALPHA_NUMERIC_CHARS + "])(#|\uff03)(" + HASHTAG_ALPHA_NUMERIC + "*" + HASHTAG_ALPHA + HASHTAG_ALPHA_NUMERIC + "*)", 2);
    public static final int VALID_HASHTAG_GROUP_BEFORE = 1;
    public static final int VALID_HASHTAG_GROUP_HASH = 2;
    public static final int VALID_HASHTAG_GROUP_TAG = 3;
    public static final Pattern INVALID_HASHTAG_MATCH_END = Pattern.compile("^(?:[#\uff03]|://)");
    public static final Pattern RTL_CHARACTERS = Pattern.compile("[\u0600-\u06ff\u0750-\u077f\u0590-\u05ff\ufe70-\ufeff]");
    public static final Pattern AT_SIGNS = Pattern.compile("[" + AT_SIGNS_CHARS + "]");
    public static final Pattern VALID_MENTION_OR_LIST = Pattern.compile("([^a-z0-9_!#$%&*" + AT_SIGNS_CHARS + "]|^|RT:?)(" + AT_SIGNS + "+)([a-z0-9_]{1,20})(/[a-z][a-z0-9_\\-]{0,24})?", 2);
    public static final int VALID_MENTION_OR_LIST_GROUP_BEFORE = 1;
    public static final int VALID_MENTION_OR_LIST_GROUP_AT = 2;
    public static final int VALID_MENTION_OR_LIST_GROUP_USERNAME = 3;
    public static final int VALID_MENTION_OR_LIST_GROUP_LIST = 4;
    public static final Pattern VALID_REPLY = Pattern.compile("^(?:[\\u0009-\\u000d\\u0020\\u0085\\u00a0\\u1680\\u180E\\u2000-\\u200a\\u2028\\u2029\\u202F\\u205F\\u3000])*" + AT_SIGNS + "([a-z0-9_]{1,20})", 2);
    public static final int VALID_REPLY_GROUP_USERNAME = 1;
    public static final Pattern INVALID_MENTION_MATCH_END = Pattern.compile("^(?:[" + AT_SIGNS_CHARS + LATIN_ACCENTS_CHARS + "]|://)");
    public static final Pattern VALID_URL = Pattern.compile(VALID_URL_PATTERN_STRING, 2);
    public static final int VALID_URL_GROUP_ALL = 1;
    public static final int VALID_URL_GROUP_BEFORE = 2;
    public static final int VALID_URL_GROUP_URL = 3;
    public static final int VALID_URL_GROUP_PROTOCOL = 4;
    public static final int VALID_URL_GROUP_DOMAIN = 5;
    public static final int VALID_URL_GROUP_PORT = 6;
    public static final int VALID_URL_GROUP_PATH = 7;
    public static final int VALID_URL_GROUP_QUERY_STRING = 8;
    public static final Pattern VALID_TCO_URL = Pattern.compile("^https?:\\/\\/t\\.co\\/[a-z0-9]+", 2);
    public static final Pattern INVALID_URL_WITHOUT_PROTOCOL_MATCH_BEGIN = Pattern.compile("[-_./]$");
    public static final Pattern VALID_CASHTAG = Pattern.compile("(^|[\\u0009-\\u000d\\u0020\\u0085\\u00a0\\u1680\\u180E\\u2000-\\u200a\\u2028\\u2029\\u202F\\u205F\\u3000])(\\$)([a-z]{1,6}(?:[._][a-z]{1,2})?)(?=$|\\s|\\p{Punct})", 2);
    public static final int VALID_CASHTAG_GROUP_BEFORE = 1;
    public static final int VALID_CASHTAG_GROUP_DOLLAR = 2;
    public static final int VALID_CASHTAG_GROUP_CASHTAG = 3;
}

