/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.BoundingBox;
import com.winterwell.jgeoplanet.IGeoCode;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.jgeoplanet.ISO3166;
import com.winterwell.jgeoplanet.LengthUnit;
import com.winterwell.jgeoplanet.Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SimplePlace
implements IPlace,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final IPlace NO_SUCH_PLACE = new SimplePlace("X");
    private String xid;
    private Collection<String> names;
    private String name;
    private String raw;
    private Class<? extends IGeoCode> geocoder;
    private BoundingBox bbox;
    private String country;
    Location centroid;
    String type;
    private IPlace parent;
    private String coder;
    private transient boolean genUID;

    public String getRaw() {
        return this.raw;
    }

    @Override
    public Class<? extends IGeoCode> getGeoCoder() {
        return this.geocoder;
    }

    public void setGeocoder(Class<? extends IGeoCode> clazz) {
        this.geocoder = clazz;
    }

    public void setRawAndCoder(String string, String string2) {
        this.raw = string;
        this.coder = string2;
    }

    public SimplePlace setParent(IPlace iPlace) {
        this.parent = iPlace;
        return this;
    }

    public SimplePlace setCountry(String string) {
        if (this.genUID) {
            this.xid = null;
        }
        this.country = string;
        return this;
    }

    @Override
    public String getUID() {
        if (this.xid == null) {
            this.genUID = true;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.name != null) {
                stringBuilder.append(this.name + "_");
            }
            if (this.country != null) {
                stringBuilder.append(this.country + "_");
            }
            if (this.centroid != null) {
                stringBuilder.append(this.centroid + "_");
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
            }
            stringBuilder.append("@simple");
            this.xid = stringBuilder.toString();
        }
        return this.xid;
    }

    public SimplePlace setType(String string) {
        if (this.genUID) {
            this.xid = null;
        }
        this.type = string;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.name == null ? (this.bbox == null ? this.country : this.bbox.toString()) : this.name;
    }

    public SimplePlace(String string, BoundingBox boundingBox, String string2) {
        if (string == null && boundingBox == null && string2 == null) {
            throw new NullPointerException("all null place");
        }
        this.name = string;
        this.bbox = boundingBox;
        if (string2 == null && string != null) {
            string2 = new ISO3166().getCountryCode(string);
        }
        this.country = string2;
    }

    public SimplePlace(String string) {
        this(string, null, null);
    }

    public SimplePlace(IPlace iPlace) {
        this.bbox = iPlace.getBoundingBox();
        this.centroid = iPlace.getCentroid();
        this.country = iPlace.getCountryCode();
        this.name = iPlace.getName();
        IPlace iPlace2 = iPlace.getParent();
        if (iPlace2 != null) {
            this.parent = new SimplePlace(iPlace2);
        }
        this.type = iPlace.getType();
        this.xid = iPlace.getUID();
        if (iPlace instanceof SimplePlace) {
            SimplePlace simplePlace = (SimplePlace)iPlace;
            this.raw = simplePlace.raw;
            this.coder = simplePlace.coder;
            this.genUID = simplePlace.genUID;
            this.names = simplePlace.names;
        }
    }

    public SimplePlace setName(String string) {
        this.name = string;
        return this;
    }

    public SimplePlace(Double d, Double d2) {
        this(null, new BoundingBox(new Location(d, d2), LengthUnit.METRE.dx), null);
    }

    public void setAlternativeNames(Collection<String> collection) {
        this.names = new ArrayList<String>(collection);
        if (!collection.contains(this.getName())) {
            this.names.add(this.getName());
        }
    }

    public Collection<String> getNames() {
        return this.names == null ? Collections.singletonList(this.getName()) : this.names;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCountryCode() {
        return new ISO3166().getCountryCode(this.country);
    }

    @Override
    public Location getCentroid() {
        if (this.centroid != null) {
            return this.centroid;
        }
        if (this.bbox != null) {
            return this.bbox.getCenter();
        }
        return null;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    @Override
    public IPlace getParent() {
        return this.parent;
    }

    public void setUID(String string) {
        this.xid = string;
        this.genUID = false;
    }

    public String getCoder() {
        return this.coder;
    }
}

