/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.BoundingBox;
import com.winterwell.jgeoplanet.Dx;
import com.winterwell.jgeoplanet.GeoCodeQuery;
import com.winterwell.jgeoplanet.IGeoCode;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.jgeoplanet.ISO3166;
import com.winterwell.jgeoplanet.Location;
import com.winterwell.jgeoplanet.PlaceNotFoundException;
import com.winterwell.jgeoplanet.SimplePlace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import winterwell.jtwitter.InternalUtils;

public class LocalGeocoder
implements IGeoCode {
    private final Map<String, IPlace> canonDesc2place = new HashMap<String, IPlace>();
    List<SimplePlace> places = new ArrayList<SimplePlace>();

    public LocalGeocoder() throws RuntimeException {
        try {
            Map<String, List<String>> map = this.loadISO3166NameData();
            this.loadWikipedia("LocalGeocoder_wikipedia_cities.txt");
            this.loadCSV("LocalGeocoder_cities.csv", null);
            this.loadCSV("LocalGeocoder_countries.csv", map);
            InternalUtils.log("geo", "LocalGeocoder loaded " + this.places.size());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void loadWikipedia(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(LocalGeocoder.class.getResourceAsStream(string)));
        HashMap<String, CallSite> hashMap = new HashMap<String, CallSite>();
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if (string2.contains("Gaza")) {
                System.out.println(string2);
            }
            if ((stringArray = string2.split("\\|\\|")).length < 5) continue;
            Pattern pattern = Pattern.compile("(\\d+)\u00b0(\\d+)\u2032(\\d*\"?)([NESW])");
            Matcher matcher = pattern.matcher(stringArray[0]);
            Matcher matcher2 = pattern.matcher(stringArray[1]);
            if (!matcher.find() || !matcher2.find()) continue;
            double d = Double.valueOf(matcher.group(1));
            double d2 = Double.valueOf(matcher.group(2));
            double d3 = Double.valueOf(matcher2.group(1));
            double d4 = Double.valueOf(matcher2.group(2));
            double d5 = d + d2 / 60.0;
            double d6 = d3 + d4 / 60.0;
            String string3 = matcher2.group(4);
            String string4 = matcher.group(4);
            if (string4.equals("S")) {
                d5 = -d5;
            }
            if (string3.equals("W")) {
                d6 = -d6;
            }
            String string5 = stringArray[2];
            String[] stringArray2 = string5.split("\\|");
            String string6 = stringArray2[stringArray2.length - 1].trim();
            string6 = InternalUtils.trimPunctuation(string6);
            String string7 = stringArray[4];
            string7 = string7.replaceFirst("<!--.+-->", "");
            if ((string7 = InternalUtils.removePunctuation(string7).trim()).length() < 2) continue;
            ISO3166 iSO3166 = new ISO3166();
            String string8 = string7.substring(0, 2);
            switch (string7) {
                case "DZA": {
                    string8 = "Algeria";
                    break;
                }
                case "ARE": {
                    string8 = "United Arab Emirates";
                    break;
                }
                case "BUR": {
                    string8 = "Burma";
                    break;
                }
                case "DEN": 
                case "DNK": {
                    string8 = "Denmark";
                    break;
                }
                case "DJI": {
                    string8 = "Djibouti";
                    break;
                }
                case "EGY": {
                    string8 = "Egypt";
                    break;
                }
                case "GER": {
                    string8 = "Germany";
                    break;
                }
                case "SWE": {
                    string8 = "Sweden";
                    break;
                }
                case "KAZ": {
                    string8 = "Kazakhstan";
                    break;
                }
                case "MAS": {
                    string8 = "Malaysia";
                    break;
                }
                case "MRT": {
                    string8 = "Mauritania";
                    break;
                }
                case "POL": {
                    string8 = "Poland";
                    break;
                }
                case "SIN": {
                    string8 = "Singapore";
                    break;
                }
                case "SAM": {
                    string8 = "Samoa";
                    break;
                }
                case "SOM": {
                    string8 = "Somalia";
                    break;
                }
                case "IRQ": {
                    string8 = "Iraq";
                    break;
                }
                case "ISR": 
                case "ISR Disputed": {
                    string8 = "Israel";
                    break;
                }
                case "PSE": 
                case "PLE": {
                    string8 = "Palestine";
                    break;
                }
                case "COM": {
                    string8 = "Comoros";
                    break;
                }
                case "CRO": {
                    string8 = "Croatia";
                    break;
                }
                case "PRC": {
                    string8 = "China";
                    break;
                }
                case "TUN": {
                    string8 = "Tunisia";
                    break;
                }
                case "TUR": {
                    string8 = "Turkey";
                    break;
                }
                case "POR": {
                    string8 = "Portugal";
                    break;
                }
                case "KOR": {
                    string8 = "Korea";
                    break;
                }
                case "HAI": {
                    string8 = "Haiti";
                    break;
                }
                case "JAM": {
                    string8 = "Jamaica";
                    break;
                }
                case "ZIM": {
                    string8 = "Zimbabwe";
                }
            }
            String string9 = iSO3166.getCountryCode(string8);
            if (string9 == null) continue;
            String string10 = iSO3166.getEverydayName(string9);
            hashMap.put(string7, (CallSite)((Object)(string10 + " from " + string5)));
            Location location = new Location(d5, d6);
            SimplePlace simplePlace = new SimplePlace(string6, null, string9);
            simplePlace.setGeocoder(this.getClass());
            simplePlace.type = "city";
            simplePlace.centroid = location;
            this.places.add(simplePlace);
            String string11 = this.canonical(string6);
            if (string11.isEmpty() || this.canonDesc2place.containsKey(string11)) continue;
            this.canonDesc2place.put(string11, simplePlace);
        }
    }

    private void loadCSV(String string, Map<String, List<String>> map) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(LocalGeocoder.class.getResourceAsStream(string)));
        this.loadCSV(bufferedReader, map);
    }

    public IPlace getPlace(Location location) throws PlaceNotFoundException {
        GeoCodeQuery geoCodeQuery = new GeoCodeQuery().setLocation(location);
        return this.getBestPlace(geoCodeQuery);
    }

    @Override
    public IPlace getPlace(String string) {
        Map<IPlace, Double> map = this.getPlace(new GeoCodeQuery(string));
        if (map.isEmpty()) {
            return null;
        }
        return InternalUtils.getBest(map);
    }

    @Override
    public Map<IPlace, Double> getPlace(GeoCodeQuery geoCodeQuery) {
        String string = geoCodeQuery.desc;
        Location location = geoCodeQuery.locn;
        if (location == null) {
            location = Location.parse(string);
        }
        if (location != null) {
            Map<IPlace, Double> map = this.getPlace2(location);
            return map;
        }
        String string2 = this.canonical(string);
        IPlace iPlace = this.canonDesc2place.get(string2);
        if (iPlace != null) {
            return Collections.singletonMap(iPlace, 0.8);
        }
        throw new PlaceNotFoundException(string);
    }

    private Map<IPlace, Double> getPlace2(Location location) {
        if (location.latitude == 0.0 && location.longitude == 0.0) {
            return Collections.emptyMap();
        }
        ArrayList<IPlace> arrayList = new ArrayList<IPlace>();
        Dx dx = new Dx(40000.0);
        for (IPlace object : this.places) {
            Object object2 = object.getBoundingBox();
            if (object2 == null) {
                Dx dx2;
                if (object.getCentroid() == null || !(dx2 = location.distance(object.getCentroid())).isShorterThan(dx)) continue;
                return Collections.singletonMap(object, 0.98);
            }
            if (!((BoundingBox)object2).contains(location)) continue;
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            throw new PlaceNotFoundException(location.toString());
        }
        HashMap hashMap = new HashMap();
        for (Object object2 : arrayList) {
            hashMap.put(object2, 0.95);
        }
        return hashMap;
    }

    public IPlace getPlaceLenient(String string) {
        IPlace iPlace;
        Location location = Location.parse(string);
        if (location != null) {
            return this.getPlace(location);
        }
        try {
            iPlace = this.getPlace(string);
            if (iPlace != null) {
                return iPlace;
            }
        }
        catch (PlaceNotFoundException placeNotFoundException) {
            // empty catch block
        }
        iPlace = this.getPlaceLenient2(string);
        return iPlace;
    }

    @Override
    public Boolean matches(GeoCodeQuery geoCodeQuery, IPlace iPlace) {
        return InternalUtils.geoMatch(geoCodeQuery, iPlace);
    }

    public SimplePlace getPlaceLenient2(String string) {
        String string2 = this.canonical(string);
        for (SimplePlace simplePlace : this.places) {
            for (String string3 : simplePlace.getNames()) {
                Pattern pattern;
                String string4 = this.canonical(string3);
                if (string4.isEmpty() || !(pattern = string4.length() < 5 ? Pattern.compile("\\b" + string4 + "\\b", 2) : Pattern.compile("\\b" + string4, 2)).matcher(string2).find()) continue;
                return simplePlace;
            }
        }
        return null;
    }

    String canonical(String string) {
        if (string == null) {
            return null;
        }
        return InternalUtils.toCanonical(string);
    }

    public LocalGeocoder(BufferedReader bufferedReader) throws IOException {
        this.loadCSV(bufferedReader, null);
    }

    void loadCSV(BufferedReader bufferedReader, Map<String, List<String>> map) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            Object object2;
            Object object3;
            SimplePlace simplePlace;
            String[] stringArray = string.split("\\|");
            if (stringArray.length < 2) continue;
            String[] stringArray2 = stringArray[1].trim().split(";");
            String string2 = stringArray[0].trim();
            if (stringArray.length < 5) {
                simplePlace = new SimplePlace(stringArray2[0], null, string2);
                simplePlace.setGeocoder(this.getClass());
            } else {
                object3 = new Location(Double.valueOf(stringArray[2]), Double.valueOf(stringArray[3]));
                object2 = new Location(Double.valueOf(stringArray[4]), Double.valueOf(stringArray[5]));
                object = new BoundingBox((Location)object3, (Location)object2);
                simplePlace = new SimplePlace(stringArray2[0], (BoundingBox)object, string2);
                simplePlace.setGeocoder(this.getClass());
            }
            if (stringArray.length > 6) {
                simplePlace.centroid = object3 = new Location(Double.valueOf(stringArray[6]), Double.valueOf(stringArray[7]));
            }
            this.loadCSV2_altNames(stringArray2, simplePlace, map);
            this.places.add(simplePlace);
            object3 = simplePlace.getNames().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = this.canonical((String)object2);
                if (((String)object).isEmpty()) continue;
                this.canonDesc2place.put((String)object, simplePlace);
            }
        }
        bufferedReader.close();
    }

    private void loadCSV2_altNames(String[] stringArray, SimplePlace simplePlace, Map<String, List<String>> map) {
        String string;
        List<String> list;
        if (stringArray.length > 1) {
            simplePlace.setAlternativeNames(Arrays.asList(stringArray));
            return;
        }
        ISO3166 iSO3166 = new ISO3166();
        if (map != null && iSO3166.getCountryCode(simplePlace.getName()) != null && (list = map.get(string = iSO3166.getCountryCode(simplePlace.getName()))) != null) {
            simplePlace.setAlternativeNames(list);
        }
    }

    Map<String, List<String>> loadISO3166NameData() throws IOException {
        InputStream inputStream = ISO3166.class.getResourceAsStream("iso-3166-country-codes.csv");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            String[] stringArray2 = string.split("\t");
            String string2 = stringArray2[1].toUpperCase();
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string2, arrayList);
            }
            arrayList.add(stringArray2[0]);
            if (stringArray2.length <= 5 || stringArray2[5].isEmpty()) continue;
            for (String string3 : stringArray = stringArray2[5].split(";")) {
                arrayList.add(string3);
            }
        }
        return hashMap;
    }

    public IPlace getBestPlace(GeoCodeQuery geoCodeQuery) {
        Map<IPlace, Double> map = this.getPlace(geoCodeQuery);
        IPlace iPlace = null;
        double d = Double.NEGATIVE_INFINITY;
        for (IPlace iPlace2 : map.keySet()) {
            Double d2 = map.get(iPlace2);
            if (d2 == null || !(d2 > d)) continue;
            iPlace = iPlace2;
            d = d2;
        }
        return iPlace;
    }
}

