/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import winterwell.jtwitter.InternalUtils;

public final class ISO3166 {
    static Map<String, String> code2name;
    static Map<String, String> code2everydayName;
    static Map<String, String> name2code;
    public static final String UNKNOWN_COUNTRY = "XX";

    public List<String> getAllNames(String string) {
        String string2 = this.getCountryCode(string);
        if (string2 == null) {
            throw new IllegalArgumentException(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : name2code.entrySet()) {
            if (!string2.equals(entry.getValue()) || arrayList.contains(entry.getKey())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    private static void init() {
        if (code2name != null) {
            return;
        }
        try {
            code2name = new HashMap<String, String>();
            name2code = new HashMap<String, String>();
            code2everydayName = new HashMap<String, String>();
            InputStream inputStream = ISO3166.class.getResourceAsStream("iso-3166-country-codes.csv");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\t");
                String string2 = stringArray[1].toUpperCase();
                code2name.put(string2, stringArray[0]);
                String string3 = ISO3166.canon(stringArray[0]);
                name2code.put(string3, string2);
                if (stringArray.length <= 5 || stringArray[5].isEmpty()) continue;
                String[] stringArray2 = stringArray[5].split(";");
                if (stringArray[0].contains("(") || stringArray[0].contains(",") || string3.contains("republic") || string3.startsWith("libyan")) {
                    assert (stringArray2[0] != null);
                    code2everydayName.put(string2, stringArray2[0]);
                }
                for (String string4 : stringArray2) {
                    string4 = ISO3166.canon(string4);
                    String string5 = name2code.get(string4);
                    assert (string5 == null || string5.equals(string2)) : string5 + " vs " + string2 + " for " + string4;
                    name2code.put(string4, string2);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String canon(String string) {
        return InternalUtils.toCanonical(string).replace(" ", "");
    }

    public String getName(String string) {
        ISO3166.init();
        String string2 = this.getCountryCode(string);
        String string3 = code2name.get(string2);
        return string3;
    }

    @Deprecated
    List<String> getAllNamesForCode(String string) {
        string = this.getCountryCode(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : name2code.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            arrayList.add(entry.getKey());
        }
        assert (!arrayList.isEmpty()) : string;
        return arrayList;
    }

    public String getCountryCode(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        ISO3166.init();
        if (string.length() == 2 && code2name.containsKey(string2 = string.toUpperCase())) {
            return string2;
        }
        string = ISO3166.canon(string);
        return name2code.get(string);
    }

    public boolean is2LetterCode(String string) {
        ISO3166.init();
        if (string == null) {
            return false;
        }
        return code2name.containsKey(string.toUpperCase());
    }

    public Set<String> getCodes() {
        ISO3166.init();
        return code2name.keySet();
    }

    public String getEverydayName(String string) {
        assert (string != null);
        ISO3166.init();
        String string2 = this.getCountryCode(string);
        String string3 = code2everydayName.get(string2);
        if (string3 != null) {
            return string3;
        }
        return this.getName(string2);
    }

    public Map getName2Code() {
        return name2code;
    }
}

