/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.LengthUnit;

public final class Dx
implements Comparable<Dx> {
    private static final long serialVersionUID = 1L;
    private final LengthUnit unit;
    private final double n;

    public static Dx ZERO() {
        return new Dx(0.0, LengthUnit.METRE);
    }

    public Dx(double d) {
        this(d, LengthUnit.METRE);
    }

    public Dx(double d, LengthUnit lengthUnit) {
        this.n = d;
        this.unit = lengthUnit;
        assert (lengthUnit != null);
    }

    public double getMetres() {
        return this.unit.metres * this.n;
    }

    public double getValue() {
        return this.n;
    }

    public LengthUnit geKLength() {
        return this.unit;
    }

    public String toString() {
        return (float)this.n + " " + this.unit.toString().toLowerCase() + (this.n != 1.0 ? "s" : "");
    }

    public boolean isShorterThan(Dx dx) {
        assert (dx != null);
        return Math.abs(this.getMetres()) < Math.abs(dx.getMetres());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != Dx.class) {
            return false;
        }
        Dx dx = (Dx)object;
        return this.getMetres() == dx.getMetres();
    }

    public int hashCode() {
        return new Double(this.getMetres()).hashCode();
    }

    public Dx multiply(double d) {
        return new Dx(d * this.n, this.unit);
    }

    @Override
    public int compareTo(Dx dx) {
        double d;
        double d2 = this.getMetres();
        if (d2 == (d = dx.getMetres())) {
            return 0;
        }
        return d2 < d ? -1 : 1;
    }

    public Dx convertTo(LengthUnit lengthUnit) {
        if (this.unit == lengthUnit) {
            return this;
        }
        double d = this.divide(lengthUnit.dx);
        return new Dx(d, lengthUnit);
    }

    public double divide(Dx dx) {
        if (this.n == 0.0) {
            return 0.0;
        }
        return this.n * this.unit.metres / (dx.n * dx.unit.metres);
    }
}

