/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.GeoPlanet;
import com.winterwell.jgeoplanet.GeoPlanetResource;
import org.json.JSONException;
import org.json.JSONObject;

public class PlaceType
extends GeoPlanetResource {
    private final int code;
    private final String name;
    private final String description;

    PlaceType(GeoPlanet client, JSONObject placeType) throws JSONException {
        super(client);
        this.code = placeType.getJSONObject("placeTypeName attrs").getInt("code");
        this.name = placeType.getString("placeTypeName");
        this.description = placeType.getString("placeTypeDescription");
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUri() {
        return this.getClient().getServiceUri() + "/placetype/" + this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlaceType other = (PlaceType)obj;
        return this.code == other.code;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public String toString() {
        return "PlaceType [code=" + this.code + ", description=" + this.description + ", name=" + this.name + "]";
    }
}

