/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import org.json.JSONException;
import org.json.JSONObject;

public class Location {
    private static final double DIAMETER_OF_EARTH = 12756.2;
    private final double longitude;
    private final double latitiude;

    Location(JSONObject jsonObject) throws JSONException {
        this.latitiude = jsonObject.getDouble("latitude");
        this.longitude = jsonObject.getDouble("longitude");
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitiude;
    }

    protected boolean containedIn(Location northEast, Location southWest) {
        assert (northEast.latitiude >= southWest.latitiude);
        assert (northEast.longitude >= southWest.longitude);
        return this.latitiude <= northEast.latitiude && this.longitude <= northEast.longitude && this.latitiude >= southWest.latitiude && this.longitude >= southWest.longitude;
    }

    public double distance(Location other) {
        double lat = this.latitiude * Math.PI / 180.0;
        double lon = this.longitude * Math.PI / 180.0;
        double olat = other.latitiude * Math.PI / 180.0;
        double olon = other.longitude * Math.PI / 180.0;
        double sin2lat = Math.sin((lat - olat) / 2.0);
        sin2lat *= sin2lat;
        double sin2long = Math.sin((lon - olon) / 2.0);
        sin2long *= sin2long;
        return 12756.2 * Math.asin(Math.sqrt(sin2lat + Math.cos(lat) * Math.cos(olat) * sin2long));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.latitiude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (Double.doubleToLongBits(this.latitiude) != Double.doubleToLongBits(other.latitiude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }
}

