/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.GeoPlanetException;
import com.winterwell.jgeoplanet.InvalidAppIdException;
import com.winterwell.jgeoplanet.InvalidPlaceType;
import com.winterwell.jgeoplanet.Place;
import com.winterwell.jgeoplanet.PlaceCollection;
import com.winterwell.jgeoplanet.PlaceNotFoundException;
import com.winterwell.jgeoplanet.PlaceType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeoPlanet {
    public static String appIdUrl = "http://developer.yahoo.com/wsregapp/";
    private final String appId;
    private final String language;
    private final String serviceUri;
    private Map<String, PlaceType> placeTypeNameCache;
    private Map<Integer, PlaceType> placeTypeCodeCache;
    public static final String defaultServiceUri = "http://where.yahooapis.com/v1";
    public static final String defaultLanguage = "en";

    public GeoPlanet(String appId) throws GeoPlanetException {
        this(appId, defaultLanguage);
    }

    public GeoPlanet(String appId, String language) throws GeoPlanetException {
        this(appId, language, defaultServiceUri);
    }

    public GeoPlanet(String appId, String language, String serviceUri) throws GeoPlanetException {
        this.appId = appId;
        this.language = language;
        this.serviceUri = serviceUri;
        this.cachePlaceTypes();
    }

    public String getApplicationId() {
        return this.appId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public Place getPlace(long woeId) throws GeoPlanetException {
        try {
            if (woeId < 0L) {
                throw new PlaceNotFoundException("WOEID");
            }
            JSONObject place = this.doGet("/place/" + woeId, false);
            return new Place(this, place.getJSONObject("place"));
        }
        catch (PlaceNotFoundException e) {
            assert (e.getPlaceName().equals("WOEID"));
            throw new PlaceNotFoundException(woeId + " (WOE ID)");
        }
        catch (JSONException e) {
            throw new GeoPlanetException((Exception)((Object)e));
        }
    }

    public Place getPlace(String query) throws GeoPlanetException {
        List<Place> places = this.getPlaces(query).get(0, 1);
        if (places.size() == 0) {
            throw new PlaceNotFoundException(query);
        }
        return places.get(0);
    }

    public PlaceCollection getPlaces(String query) {
        return new PlaceCollection(this, query);
    }

    public Collection<PlaceType> getPlaceTypes() {
        return this.placeTypeNameCache.values();
    }

    public PlaceType getPlaceType(String placeTypeName) throws InvalidPlaceType {
        PlaceType type = this.placeTypeNameCache.get(placeTypeName);
        if (type == null) {
            throw new InvalidPlaceType(placeTypeName);
        }
        return type;
    }

    public PlaceType getPlaceType(int placeTypeCode) throws InvalidPlaceType {
        PlaceType type = this.placeTypeCodeCache.get(placeTypeCode);
        if (type == null) {
            throw new InvalidPlaceType(placeTypeCode + " (code)");
        }
        return type;
    }

    private synchronized void cachePlaceTypes() throws GeoPlanetException {
        if (this.placeTypeNameCache != null) {
            return;
        }
        try {
            this.placeTypeCodeCache = new HashMap<Integer, PlaceType>();
            this.placeTypeNameCache = new HashMap<String, PlaceType>();
            JSONObject tmp = this.doGet("/placetypes", false);
            tmp = tmp.getJSONObject("placeTypes");
            JSONArray types = tmp.getJSONArray("placeType");
            for (int i = 0; i < types.length(); ++i) {
                PlaceType type = new PlaceType(this, types.getJSONObject(i));
                this.placeTypeCodeCache.put(type.getCode(), type);
                this.placeTypeNameCache.put(type.getName(), type);
            }
        }
        catch (JSONException e) {
            throw new GeoPlanetException((Exception)((Object)e));
        }
    }

    JSONObject doGet(String path, boolean shortForm) throws GeoPlanetException, PlaceNotFoundException {
        assert (path.startsWith("/"));
        StringBuilder uri = new StringBuilder(this.serviceUri);
        uri.append(path);
        uri.append("?");
        uri.append("appid=");
        uri.append(this.appId);
        uri.append("&format=json");
        uri.append("&select=");
        uri.append(shortForm ? "short" : "long");
        uri.append("&lang=");
        uri.append(this.language);
        try {
            GetMethod get = new GetMethod(URIUtil.encodePathQuery((String)uri.toString()));
            HttpClient httpClient = new HttpClient();
            httpClient.executeMethod((HttpMethod)get);
            String response = get.getResponseBodyAsString();
            switch (get.getStatusCode()) {
                case 200: {
                    break;
                }
                case 400: {
                    throw new InvalidAppIdException(this.appId);
                }
                case 404: {
                    throw new PlaceNotFoundException("WOEID");
                }
                default: {
                    throw new GeoPlanetException("Unexpected response from GeoPlanet server: " + get.getStatusLine());
                }
            }
            return new JSONObject(response);
        }
        catch (HttpException e) {
            throw new GeoPlanetException((Exception)((Object)e));
        }
        catch (JSONException e) {
            throw new GeoPlanetException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new GeoPlanetException(e);
        }
    }

    public String toString() {
        return "WhereOnEarth client [appId=" + this.appId + ", lang=" + this.language + "]";
    }
}

